/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.query.SortClause;

public class SortOrder {
    final List<SortClause> sortClauses = new ArrayList<SortClause>();

    public SortOrder() {
    }

    public SortOrder(String ... properties) {
        this(Direction.ASC, properties);
    }

    public SortOrder(Direction direction, String ... properties) {
        this();
        this.add(direction, properties);
    }

    public static SortOrder fromSortClauses(List<SortClause> sortClauses) {
        SortOrder sortOrder = new SortOrder();
        sortOrder.sortClauses.addAll(sortClauses);
        return sortOrder;
    }

    public SortOrder add(String ... properties) {
        return this.add(Direction.ASC, properties);
    }

    public SortOrder add(Direction direction, String ... properties) {
        this.sortClauses.add(new SortClause(direction, properties));
        return this;
    }

    public SortOrder asc(String ... properties) {
        return this.add(Direction.ASC, properties);
    }

    public SortOrder desc(String ... properties) {
        return this.add(Direction.DESC, properties);
    }

    public List<SortClause> sortClauses() {
        return this.sortClauses;
    }

    public boolean hasSortClauses() {
        return !this.sortClauses.isEmpty();
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (!this.sortClauses.isEmpty()) {
            sb.append(" ORDER BY ");
            for (SortClause ordering : this.sortClauses) {
                sb.append(ordering.asString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

