/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Objects;
import org.neo4j.ogm.metadata.ClassInfo;

class LabelPrimaryId {
    private final String label;
    private final Object id;

    static LabelPrimaryId of(ClassInfo classInfo, Object id) {
        Objects.requireNonNull(classInfo);
        Objects.requireNonNull(id);
        return new LabelPrimaryId(classInfo, id);
    }

    private LabelPrimaryId(ClassInfo classInfo, Object id) {
        this.label = classInfo.neo4jName();
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelPrimaryId that = (LabelPrimaryId)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.id);
    }

    public String toString() {
        return String.format("LabelPrimaryId{label='%s', id=%s}", this.label, this.id);
    }
}

