/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.ogm.context.EntitySnapshot;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

class IdentityMap {
    private static final long SEED = -197749L;
    private final Map<Long, Long> nodeHashes = new HashMap<Long, Long>();
    private final Map<Long, Long> relEntityHashes = new HashMap<Long, Long>();
    private final Map<Long, EntitySnapshot> snapshotsOfNodeEntities = new HashMap<Long, EntitySnapshot>();
    private final Map<Long, EntitySnapshot> snapshotsOfRelationshipEntities = new HashMap<Long, EntitySnapshot>();
    private final MetaData metaData;

    IdentityMap(MetaData metaData) {
        this.metaData = metaData;
    }

    void remember(Object object, Long entityId) {
        ClassInfo classInfo = this.metaData.classInfo(object);
        if (this.metaData.isRelationshipEntity(classInfo.name())) {
            this.relEntityHashes.put(entityId, IdentityMap.hash(object, classInfo));
            this.snapshotsOfRelationshipEntities.put(entityId, EntitySnapshot.basedOn(this.metaData).take(object));
        } else {
            this.nodeHashes.put(entityId, IdentityMap.hash(object, classInfo));
            this.snapshotsOfNodeEntities.put(entityId, EntitySnapshot.basedOn(this.metaData).take(object));
        }
    }

    boolean remembered(Object object, Long entityId) {
        long expected;
        Map<Long, Long> hashes;
        if (entityId == null) {
            return false;
        }
        ClassInfo classInfo = this.metaData.classInfo(object);
        boolean isRelEntity = this.metaData.isRelationshipEntity(classInfo.name());
        Map<Long, Long> map = hashes = isRelEntity ? this.relEntityHashes : this.nodeHashes;
        if (!hashes.containsKey(entityId)) {
            return false;
        }
        long actual = IdentityMap.hash(object, classInfo);
        return actual == (expected = hashes.get(entityId).longValue());
    }

    Optional<EntitySnapshot> getSnapshotOf(Object entity, Long entityId) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        EntitySnapshot entitySnapshot = this.metaData.isRelationshipEntity(classInfo.name()) ? this.snapshotsOfRelationshipEntities.get(entityId) : this.snapshotsOfNodeEntities.get(entityId);
        return Optional.ofNullable(entitySnapshot);
    }

    void clear() {
        this.nodeHashes.clear();
        this.relEntityHashes.clear();
        this.snapshotsOfNodeEntities.clear();
        this.snapshotsOfRelationshipEntities.clear();
    }

    private static long hash(Object object, ClassInfo classInfo) {
        ArrayList<FieldInfo> hashFields = new ArrayList<FieldInfo>(classInfo.propertyFields());
        if (classInfo.labelFieldOrNull() != null) {
            hashFields.add(classInfo.labelFieldOrNull());
        }
        long hash = -197749L;
        for (FieldInfo fieldInfo : hashFields) {
            Object value = fieldInfo.read(object);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                hash = hash * 31L + IdentityMap.hashArray(value);
                continue;
            }
            hash = hash * 31L + (long)value.hashCode();
        }
        return hash;
    }

    private static long hashArray(Object array) {
        long result = 1L;
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object element = Array.get(array, i);
            result = 31L * result + (long)(element == null ? 0 : element.hashCode());
        }
        return result;
    }
}

