/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

class EntitySnapshot {
    private final Set<String> dynamicLabels;
    private final Set<String> dynamicCompositeProperties;

    private EntitySnapshot(Set<String> dynamicLabels, Set<String> dynamicCompositeProperties) {
        this.dynamicLabels = dynamicLabels;
        this.dynamicCompositeProperties = dynamicCompositeProperties;
    }

    public Set<String> getDynamicLabels() {
        return this.dynamicLabels;
    }

    public Set<String> getDynamicCompositeProperties() {
        return this.dynamicCompositeProperties;
    }

    static Builder basedOn(MetaData metaData) {
        return new Builder(metaData);
    }

    static class Builder {
        private final MetaData metaData;

        Builder(MetaData metaData) {
            this.metaData = metaData;
        }

        EntitySnapshot take(Object entity) {
            ClassInfo classInfo = this.metaData.classInfo(entity);
            Set<String> labels = Builder.extractLabels(classInfo, entity);
            Set<String> compositeProperties = Builder.extractCompositeProperties(classInfo, entity);
            return new EntitySnapshot(labels, compositeProperties);
        }

        private static Set<String> extractLabels(ClassInfo classInfo, Object entity) {
            return Optional.ofNullable(classInfo.labelFieldOrNull()).map(labelField -> labelField.read(entity)).map(Builder::unsafeCastLabels).map(Collections::unmodifiableSet).orElse(Collections.emptySet());
        }

        private static Set<String> extractCompositeProperties(ClassInfo classInfo, Object entity) {
            return classInfo.propertyFields().stream().filter(FieldInfo::isComposite).flatMap(f -> f.readComposite(entity).keySet().stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }

        private static Set<String> unsafeCastLabels(Object labels) {
            return new HashSet<String>((Collection)labels);
        }
    }
}

