/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import org.neo4j.ogm.cypher.query.SortOrder;

public class SortClause {
    private final SortOrder.Direction direction;
    private final String[] properties;
    private final boolean ignoreCase;

    SortClause(SortOrder.Direction direction, boolean ignoreCase, String ... properties) {
        this.direction = direction;
        this.ignoreCase = ignoreCase;
        this.properties = properties;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public SortClause fromResolvedProperties(String ... resolvedProperties) {
        if (resolvedProperties.length != this.properties.length) {
            throw new IllegalArgumentException("Resolved properties count must match existing properties count.");
        }
        return new SortClause(this.direction, this.ignoreCase, resolvedProperties);
    }

    String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.properties.length > 0) {
            for (String n : this.properties) {
                if (this.ignoreCase) {
                    sb.append("toLower(");
                }
                sb.append("$.").append(n);
                if (this.ignoreCase) {
                    sb.append(")");
                }
                if (this.direction == SortOrder.Direction.DESC) {
                    sb.append(" DESC");
                }
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

