/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.DistanceFromNativePoint;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class NativeDistanceComparison
implements FilterFunction<DistanceFromNativePoint> {
    private static final String DISTANCE_VALUE_PARAMETER = "distanceValue";
    private static final String OGM_POINT_PARAMETER = "ogmPoint";
    protected final ComparisonOperator operator;
    protected final DistanceFromNativePoint distanceFromNativePoint;

    private NativeDistanceComparison(ComparisonOperator operator, DistanceFromNativePoint distanceFromNativePoint) {
        this.operator = operator;
        this.distanceFromNativePoint = distanceFromNativePoint;
    }

    public static NativeDistanceComparison distanceComparisonFor(DistanceFromNativePoint distanceFromNativePoint) {
        return NativeDistanceComparison.distanceComparisonFor(ComparisonOperator.LESS_THAN, distanceFromNativePoint);
    }

    public static NativeDistanceComparison distanceComparisonFor(ComparisonOperator operator, DistanceFromNativePoint distanceFromNativePoint) {
        return new NativeDistanceComparison(operator, distanceFromNativePoint);
    }

    @Override
    public DistanceFromNativePoint getValue() {
        return this.distanceFromNativePoint;
    }

    @Override
    public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
        String pointPropertyOfEntity = nodeIdentifier + "." + filteredProperty;
        String comparisonOperator = this.operator.getValue();
        return String.format("point.distance($%s,%s) %s $%s ", OGM_POINT_PARAMETER, pointPropertyOfEntity, comparisonOperator, DISTANCE_VALUE_PARAMETER);
    }

    @Override
    public Map<String, Object> parameters(UnaryOperator<String> createUniqueParameterName, PropertyValueTransformer valueTransformer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(OGM_POINT_PARAMETER, this.distanceFromNativePoint.getPoint());
        map.put(DISTANCE_VALUE_PARAMETER, this.distanceFromNativePoint.getDistance());
        return map;
    }
}

