/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class ContainsAnyComparison
implements FilterFunction<Object> {
    protected static final String PARAMETER_NAME = "property";
    private final Object value;

    public ContainsAnyComparison(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
        return String.format("ANY(collectionFields IN $`%s` WHERE collectionFields in %s.`%s`) ", createUniqueParameterName.apply(PARAMETER_NAME), nodeIdentifier, filteredProperty);
    }

    @Override
    public Map<String, Object> parameters(UnaryOperator<String> createUniqueParameterName, PropertyValueTransformer propertyValueTransformer) {
        return Collections.singletonMap((String)createUniqueParameterName.apply(PARAMETER_NAME), propertyValueTransformer.transformPropertyValue(this.value));
    }
}

