/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.utils.StringUtils;

public class EnumStringConverter
implements AttributeConverter<Enum, String> {
    private final Class<? extends Enum> enumClass;
    private final boolean lenient;

    public EnumStringConverter(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        this.lenient = false;
    }

    public EnumStringConverter(Class<? extends Enum> enumClass, boolean lenient) {
        this.enumClass = enumClass;
        this.lenient = lenient;
    }

    @Override
    public String toGraphProperty(Enum value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    @Override
    public Enum toEntityAttribute(String value) {
        if (value == null || this.lenient && StringUtils.isBlank(value)) {
            return null;
        }
        return Enum.valueOf(this.enumClass, value);
    }
}

