/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public abstract class AbstractTransactionManager
implements TransactionManager {
    private final Session session;
    private final BiFunction<Transaction.Type, Iterable<String>, Transaction> transactionFactory;

    protected AbstractTransactionManager(Driver driver, Session session) {
        this.session = session;
        this.transactionFactory = (BiFunction)driver.getTransactionFactorySupplier().apply(this);
    }

    public final void bookmark(String bookmark) {
        if (this.session != null) {
            this.session.withBookmark(bookmark);
        }
    }

    public final Transaction openTransaction() {
        return this.openTransaction(null, Set.of());
    }

    public final Transaction openTransaction(Transaction.Type type, Iterable<String> bookmarks) {
        return this.openOrExtend(() -> this.transactionFactory.apply(type == null ? Transaction.Type.READ_WRITE : type, bookmarks), transaction -> {
            if (!(transaction instanceof AbstractTransaction)) {
                throw new IllegalStateException("There's already an ongoing transaction for the current thread and it is not extendable.");
            }
            AbstractTransaction abstractTransaction = (AbstractTransaction)transaction;
            abstractTransaction.extend(type == null ? abstractTransaction.type() : type);
            return abstractTransaction;
        });
    }

    protected abstract Transaction openOrExtend(Supplier<Transaction> var1, UnaryOperator<Transaction> var2);

    public final void close(Transaction transaction, Consumer<TransactionManager.TransactionClosedListener> callback) {
        this.removeIfCurrent(transaction, () -> callback.accept((status, entities) -> {
            if (status == Transaction.Status.ROLLEDBACK) {
                MappingContext mappingContext = ((Neo4jSession)this.session).context();
                entities.forEach(mappingContext::reset);
            }
        }));
    }

    protected abstract void removeIfCurrent(Transaction var1, Runnable var2);
}

