/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

class PrincipalNodeMatchClause
implements MatchClause {
    private final String varName;
    private StringBuilder clause;

    PrincipalNodeMatchClause(String label) {
        this(label, "n");
    }

    PrincipalNodeMatchClause(String label, String varName) {
        this.varName = varName;
        this.clause = new StringBuilder();
        this.clause.append(String.format("MATCH (%s:`%s`) ", varName, label));
    }

    @Override
    public MatchClause append(Filter filter) {
        this.clause.append(filter.toCypher(this.varName, this.clause.indexOf(" WHERE ") == -1));
        return this;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }
}

