/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class DistanceComparison
implements FilterFunction<DistanceFromPoint> {
    private static final String LATITUDE_PROPERTY_SUFFIX = ".latitude";
    private static final String LONGITUDE_PROPERTY_SUFFIX = ".longitude";
    protected final ComparisonOperator operator;
    protected final DistanceFromPoint value;

    public DistanceComparison(DistanceFromPoint value) {
        this(ComparisonOperator.LESS_THAN, value);
    }

    public DistanceComparison(ComparisonOperator operator, DistanceFromPoint value) {
        this.operator = operator;
        this.value = value;
    }

    public DistanceComparison withOperator(ComparisonOperator newOperator) {
        return this.operator == newOperator ? this : new DistanceComparison(newOperator, this.value);
    }

    @Override
    public DistanceFromPoint getValue() {
        return this.value;
    }

    @Override
    public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
        String latitude = nodeIdentifier + LATITUDE_PROPERTY_SUFFIX;
        String longitude = nodeIdentifier + LONGITUDE_PROPERTY_SUFFIX;
        return String.format("point.distance(point({latitude: %s, longitude: %s}),point({latitude: $lat, longitude: $lon})) %s $distance ", latitude, longitude, this.operator.getValue());
    }

    @Override
    public Map<String, Object> parameters(UnaryOperator<String> createUniqueParameterName, PropertyValueTransformer valueTransformer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lat", this.value.getLatitude());
        map.put("lon", this.value.getLongitude());
        map.put("distance", this.value.getDistance());
        return map;
    }
}

