/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class PropertyComparison
implements FilterFunction<Object> {
    protected static final String PARAMETER_NAME = "property";
    protected final ComparisonOperator operator;
    protected final Object value;

    public PropertyComparison(ComparisonOperator operator, Object value) {
        this.operator = operator;
        this.value = value;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
        if (this.operator == ComparisonOperator.IS_NULL) {
            return String.format("%s.`%s` IS NULL ", nodeIdentifier, filteredProperty);
        }
        if (this.operator == ComparisonOperator.EXISTS) {
            return String.format("%s.`%s` IS NOT NULL ", nodeIdentifier, filteredProperty);
        }
        if (this.operator == ComparisonOperator.IS_TRUE) {
            return String.format("%s.`%s` = true ", nodeIdentifier, filteredProperty);
        }
        return String.format("%s.`%s` %s $`%s` ", nodeIdentifier, filteredProperty, this.operator.getValue(), createUniqueParameterName.apply(PARAMETER_NAME));
    }

    @Override
    public Map<String, Object> parameters(UnaryOperator<String> createUniqueParameterName, PropertyValueTransformer valueTransformer) {
        if (EnumSet.of(ComparisonOperator.IS_NULL, ComparisonOperator.EXISTS, ComparisonOperator.IS_TRUE).contains((Object)this.operator)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap((String)createUniqueParameterName.apply(PARAMETER_NAME), valueTransformer.andThen(this.operator.getPropertyValueTransformer()).transformPropertyValue(this.value));
    }

    public static final class CaseInsensitiveEqualsComparison
    extends PropertyComparison {
        public CaseInsensitiveEqualsComparison(ComparisonOperator operator, Object value) {
            super(operator, value);
        }

        @Override
        public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
            return String.format("toLower(%s.`%s`) %s toLower($`%s`) ", nodeIdentifier, filteredProperty, this.operator.getValue(), createUniqueParameterName.apply(PropertyComparison.PARAMETER_NAME));
        }
    }
}

