/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

public class PathMatchClause
implements MatchClause {
    private final int index;
    private final StringBuilder clause;

    PathMatchClause(int index) {
        this.index = index;
        this.clause = new StringBuilder("MATCH (n)");
    }

    @Override
    public MatchClause append(Filter filter) {
        if (filter.getRelationshipDirection() == Relationship.Direction.INCOMING) {
            this.clause.append("<");
        }
        this.clause.append(String.format("-[%s:`%s`]-", filter.isNestedRelationshipEntity() ? "r" : "", filter.getRelationshipType()));
        if (filter.getRelationshipDirection() == Relationship.Direction.OUTGOING) {
            this.clause.append(">");
        }
        this.clause.append(String.format("(%s) ", "m" + this.index));
        return this;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }
}

