/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;

public class TransientRelationship {
    private final Long src;
    private final Long tgt;
    private final Long ref;
    private final String rel;
    private final Class srcClass;
    private final Class tgtClass;

    public TransientRelationship(Long src, Long ref, String rel, Long tgt, Class srcClass, Class tgtClass) {
        this.src = src;
        this.tgt = tgt;
        this.ref = ref;
        this.rel = rel;
        this.srcClass = srcClass;
        this.tgtClass = tgtClass;
    }

    public boolean equals(Long otherSrc, RelationshipBuilder builder, Long otherTgt) {
        Boolean singleton = builder.isSingleton();
        if (this.rel.equals(builder.type()) && singleton.booleanValue()) {
            if (builder.hasDirection(Relationship.Direction.OUTGOING)) {
                if (this.src.equals(otherSrc) && this.tgt.equals(otherTgt)) {
                    return true;
                }
            } else if (builder.hasDirection(Relationship.Direction.INCOMING)) {
                if (this.src.equals(otherTgt) && this.tgt.equals(otherSrc)) {
                    return true;
                }
            } else {
                if (this.src.equals(otherSrc) && this.tgt.equals(otherTgt)) {
                    return true;
                }
                if (this.src.equals(otherTgt) && this.tgt.equals(otherSrc)) {
                    return true;
                }
            }
        }
        return false;
    }

    public Long getSrc() {
        return this.src;
    }

    public Long getTgt() {
        return this.tgt;
    }

    public Long getRef() {
        return this.ref;
    }

    public String getRel() {
        return this.rel;
    }

    public Class getSrcClass() {
        return this.srcClass;
    }

    public Class getTgtClass() {
        return this.tgtClass;
    }

    public String toString() {
        return String.format("(%s)-[%s:%s]->(%s)", this.src, this.ref, this.rel, this.tgt);
    }
}

