/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class ConverterBasedCollectionConverter<T, F>
implements AttributeConverter<Collection<T>, F[]> {
    private final Class<?> collectionClass;
    private final AttributeConverter<T, F> converter;

    public ConverterBasedCollectionConverter(Class<?> collectionClass, AttributeConverter<T, F> converter) {
        this.collectionClass = collectionClass;
        this.converter = converter;
    }

    @Override
    public F[] toGraphProperty(Collection<T> values) {
        if (values == null) {
            return null;
        }
        Object[] result = new Object[values.size()];
        int i = 0;
        for (T value : values) {
            result[i++] = this.converter.toGraphProperty(value);
        }
        return result;
    }

    @Override
    public Collection<T> toEntityAttribute(F[] values) {
        AbstractCollection result;
        if (values == null) {
            return null;
        }
        if (List.class.isAssignableFrom(this.collectionClass)) {
            result = new ArrayList(values.length);
        } else if (Vector.class.isAssignableFrom(this.collectionClass)) {
            result = new Vector(values.length);
        } else if (Set.class.isAssignableFrom(this.collectionClass)) {
            result = new HashSet(values.length);
        } else {
            return null;
        }
        try {
            for (F value : values) {
                result.add(this.converter.toEntityAttribute(value));
            }
        }
        catch (Exception e) {
            throw new MappingException("Could not map array of values " + Arrays.toString(values) + " to collection of type " + String.valueOf(this.collectionClass), e);
        }
        return result;
    }
}

