/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;

public class RelationshipDeleteStatements
implements DeleteStatements {
    @Override
    public CypherQuery delete(Long id) {
        return new DefaultRowModelRequest("MATCH (n)-[r0]->() WHERE ID(r0) = $id DELETE r0", Collections.singletonMap("id", id));
    }

    @Override
    public CypherQuery delete(Long id, Object object, ClassInfo classInfo) {
        FieldInfo versionField = classInfo.getVersionField();
        Long version = (Long)versionField.read(object);
        OptimisticLockingConfig optimisticLockingConfig = new OptimisticLockingConfig(1, classInfo.staticLabels().toArray(new String[0]), versionField.property(), (String)Optional.ofNullable(classInfo.primaryIndexField()).map(FieldInfo::propertyName).orElse(null));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("version", version);
        params.put("type", "rel");
        return new DefaultRowModelRequest("MATCH (n)-[r0]->()   WHERE ID(r0) = $id AND r0.`" + versionField.property() + "` = $version SET  r0.`" + versionField.property() + "` = r0.`" + versionField.property() + "` + 1 WITH r0  WHERE r0.`" + versionField.property() + "` = $version + 1 DELETE r0 RETURN DISTINCT ID(r0) AS id", params, optimisticLockingConfig);
    }

    @Override
    public CypherQuery delete(Collection<Long> ids) {
        return new DefaultRowModelRequest("MATCH (n)-[r0]->() WHERE ID(r0) IN $ids DELETE r0", Collections.singletonMap("ids", ids));
    }

    @Override
    public CypherQuery deleteAll() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0", Collections.emptyMap());
    }

    @Override
    public CypherQuery delete(String type) {
        return new DefaultRowModelRequest(String.format("MATCH (n)-[r0:`%s`]-() DELETE r0", type), Collections.emptyMap());
    }

    @Override
    public CypherQuery delete(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" DELETE r0");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery deleteAndList(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" DELETE r0 RETURN ID(r0)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }
}

