/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.exception.core.MissingOperatorException;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.NodeQueryBuilder;

public class FilteredQueryBuilder {
    private static void validateNestedFilters(Iterable<Filter> filters) {
        Predicate<Filter> byIsNested = f -> f.isNested() || f.isDeepNested();
        List other = StreamSupport.stream(filters::spliterator, 16, false).filter(byIsNested.negate()).collect(Collectors.toList());
        Map groupedFilters = StreamSupport.stream(filters::spliterator, 16, false).filter(byIsNested).collect(Collectors.groupingBy(filter -> {
            if (filter.isNested()) {
                return filter.isNestedRelationshipEntity() ? filter.getRelationshipType() : filter.getNestedEntityTypeLabel();
            }
            return filter.getNestedPath().get(filter.getNestedPath().size() - 1).getNestedEntityTypeLabel();
        }, TreeMap::new, Collectors.toList()));
        Predicate<Filter> hasOrOperator = filter -> BooleanOperator.OR == filter.getBooleanOperator();
        boolean throwException = false;
        if (other.isEmpty()) {
            if (groupedFilters.size() > 1) {
                throwException = groupedFilters.values().stream().anyMatch(l -> hasOrOperator.test((Filter)l.get(0)));
            }
        } else if (!groupedFilters.isEmpty()) {
            boolean bl = throwException = other.stream().anyMatch(hasOrOperator) || groupedFilters.values().stream().map(groupedFilter -> (Filter)groupedFilter.get(0)).anyMatch(hasOrOperator);
        }
        if (throwException) {
            throw new UnsupportedOperationException("Filters containing nested paths cannot be combined via the logical OR operator.");
        }
    }

    public static FilteredQuery buildNodeQuery(String nodeLabel, Iterable<Filter> filterList) {
        FilteredQueryBuilder.validateNestedFilters(filterList);
        return new NodeQueryBuilder(nodeLabel, filterList).build();
    }

    public static FilteredQuery buildRelationshipQuery(String relationshipType, Iterable<Filter> filterList) {
        FilteredQueryBuilder.validateNestedFilters(filterList);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        StringBuilder sb = FilteredQueryBuilder.constructRelationshipQuery(relationshipType, filterList, properties);
        return new FilteredQuery(sb, properties);
    }

    private static StringBuilder constructRelationshipQuery(String type, Iterable<Filter> filters, Map<String, Object> properties) {
        FilteredQuery filteredQuery;
        NodeQueryBuilder nqb;
        boolean outgoingDeepNested;
        FiltersAtStartNode outgoingDeepNestedFilters = new FiltersAtStartNode();
        FiltersAtStartNode incomingDeepNestedFilters = new FiltersAtStartNode();
        FiltersAtStartNode outgoingFilters = new FiltersAtStartNode();
        FiltersAtStartNode incomingFilters = new FiltersAtStartNode();
        ArrayList<Filter> relationshipFilters = new ArrayList<Filter>();
        Relationship.Direction initialDirection = null;
        for (Filter filter : filters) {
            if (filter.isNested() || filter.isDeepNested()) {
                if (filter.isDeepNested()) {
                    List<Filter.NestedPathSegment> nestedPath = filter.getNestedPath();
                    Filter.NestedPathSegment firstNestedPathSegment = nestedPath.get(0);
                    filter.setOwnerEntityType(firstNestedPathSegment.getPropertyType());
                    FiltersAtStartNode target = Relationship.Direction.OUTGOING == firstNestedPathSegment.getRelationshipDirection() ? outgoingDeepNestedFilters : incomingDeepNestedFilters;
                    Filter.NestedPathSegment[] newPath = new Filter.NestedPathSegment[nestedPath.size() - 1];
                    if (nestedPath.size() > 1) {
                        nestedPath.subList(1, nestedPath.size()).toArray(newPath);
                    } else {
                        target.startNodeLabel = firstNestedPathSegment.getNestedEntityTypeLabel();
                    }
                    filter.setNestedPath(newPath);
                    target.content.add(filter);
                    if (initialDirection != null) continue;
                    initialDirection = firstNestedPathSegment.getRelationshipDirection();
                    continue;
                }
                Relationship.Direction relationshipDirection = filter.getRelationshipDirection();
                FiltersAtStartNode target = Relationship.OUTGOING == relationshipDirection ? outgoingFilters : incomingFilters;
                if (initialDirection == null) {
                    initialDirection = filter.getRelationshipDirection();
                }
                FilteredQueryBuilder.addFilterToList(target, filter);
                continue;
            }
            if (relationshipFilters.isEmpty()) {
                filter.setBooleanOperator(BooleanOperator.NONE);
            } else if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName());
            }
            relationshipFilters.add(filter);
        }
        StringBuilder query = new StringBuilder();
        boolean bl = outgoingDeepNested = !outgoingDeepNestedFilters.content.isEmpty();
        if (outgoingDeepNested) {
            nqb = new NodeQueryBuilder(outgoingDeepNestedFilters.startNodeLabel, outgoingDeepNestedFilters.content, "n");
            filteredQuery = nqb.build();
            query.append(filteredQuery.statement()).append(" ");
            properties.putAll(filteredQuery.parameters());
        }
        if (!incomingDeepNestedFilters.content.isEmpty()) {
            nqb = new NodeQueryBuilder(incomingDeepNestedFilters.startNodeLabel, incomingDeepNestedFilters.content, outgoingDeepNested ? "m" : "n");
            filteredQuery = nqb.build();
            query.append(filteredQuery.statement()).append(" ");
            if (outgoingDeepNested) {
                query.append(", n ");
            }
            properties.putAll(filteredQuery.parameters());
        }
        FilteredQueryBuilder.createRelationSubquery(type, properties, outgoingFilters, incomingFilters, relationshipFilters, query, initialDirection);
        return query;
    }

    private static void addFilterToList(FiltersAtStartNode target, Filter filter) {
        if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE) && !target.content.isEmpty()) {
            throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName());
        }
        target.content.add(filter);
        if (target.startNodeLabel == null) {
            target.startNodeLabel = filter.getNestedEntityTypeLabel();
        }
    }

    private static void createRelationSubquery(String type, Map<String, Object> properties, FiltersAtStartNode filtersAtStartNode, FiltersAtStartNode filtersAtEndNode, List<Filter> relationshipFilters, StringBuilder query, Relationship.Direction initialDirection) {
        boolean hasFiltersAtEnd;
        String endLabel;
        String startLabel = filtersAtStartNode.startNodeLabel == null ? "" : ":`%s`".formatted(filtersAtStartNode.startNodeLabel);
        String string = endLabel = filtersAtEndNode.startNodeLabel == null ? "" : ":`%s`".formatted(filtersAtEndNode.startNodeLabel);
        if (initialDirection == null || initialDirection == Relationship.OUTGOING) {
            query.append(String.format("MATCH (n%s)-[r0:`%s`]->(m%s) ", startLabel, type, endLabel));
        } else {
            query.append(String.format("MATCH (n%s)<-[r0:`%s`]-(m%s) ", startLabel, type, endLabel));
        }
        boolean hasFiltersAtStart = !filtersAtStartNode.content.isEmpty();
        boolean bl = hasFiltersAtEnd = !filtersAtEndNode.content.isEmpty();
        if (!relationshipFilters.isEmpty() || hasFiltersAtStart || hasFiltersAtEnd) {
            query.append("WHERE ");
            if (!filtersAtStartNode.content.isEmpty() || !filtersAtEndNode.content.isEmpty()) {
                query.append("( ");
                FilteredQueryBuilder.appendFilters(filtersAtStartNode.content, "n", query, properties);
                if (hasFiltersAtStart && hasFiltersAtEnd && filtersAtEndNode.content.get(0).getBooleanOperator() == BooleanOperator.NONE) {
                    query.append("AND ");
                }
                FilteredQueryBuilder.appendFilters(filtersAtEndNode.content, "m", query, properties);
                query.append(")");
                if (!relationshipFilters.isEmpty()) {
                    query.append(" AND ");
                }
            }
            FilteredQueryBuilder.appendFilters(relationshipFilters, "r0", query, properties);
        }
    }

    private static void appendFilters(List<Filter> filters, String nodeIdentifier, StringBuilder query, Map<String, Object> properties) {
        for (Filter filter : filters) {
            query.append(filter.toCypher(nodeIdentifier, false));
            properties.putAll(filter.parameters());
        }
    }

    static class FiltersAtStartNode {
        String startNodeLabel;
        List<Filter> content = new ArrayList<Filter>();

        FiltersAtStartNode() {
        }
    }
}

