/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.OptimisticLockingUtils;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.PropertyContainer;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class NewNodeStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Node> newNodes;

    public NewNodeStatementBuilder(Set<Node> newNodes, StatementFactory statementFactory) {
        this.newNodes = newNodes;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.newNodes != null && this.newNodes.size() > 0) {
            boolean hasPrimaryIndex;
            Node firstNode = this.newNodes.iterator().next();
            queryBuilder.append("UNWIND $rows as row ");
            boolean bl = hasPrimaryIndex = firstNode.getPrimaryIndex() != null;
            if (hasPrimaryIndex) {
                queryBuilder.append("MERGE (n");
            } else {
                queryBuilder.append("CREATE (n");
            }
            for (String label : firstNode.getLabels()) {
                queryBuilder.append(":`").append(label).append("`");
            }
            if (hasPrimaryIndex) {
                String propertiesToMergeOn = Arrays.stream(firstNode.getPrimaryIndex().split("4f392f2f-24b6-4f83-a474-b942a77cd01a")).map(p -> p + ": row.props." + p).collect(Collectors.joining(",", "{", "}"));
                queryBuilder.append(propertiesToMergeOn);
            }
            queryBuilder.append(") ");
            if (firstNode.hasVersionProperty() && hasPrimaryIndex) {
                queryBuilder.append(OptimisticLockingUtils.getFragmentForNewOrExistingNodes((PropertyContainer)firstNode, "n"));
            }
            queryBuilder.append("SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, $type as type");
            List rows = this.newNodes.stream().map(node -> node.toRow("nodeRef")).collect(Collectors.toList());
            parameters.put("type", "node");
            parameters.put("rows", rows);
            if (firstNode.hasVersionProperty()) {
                OptimisticLockingConfig olConfig = new OptimisticLockingConfig(rows.size(), firstNode.getLabels(), (String)firstNode.getVersion().getKey(), firstNode.getPrimaryIndex());
                return this.statementFactory.statement(queryBuilder.toString(), parameters, olConfig);
            }
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

