/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.EnumSet;
import org.neo4j.ogm.cypher.CaseInsensitiveLikePropertyValueTransformer;
import org.neo4j.ogm.cypher.NoOpPropertyValueTransformer;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.PropertyComparison;

public enum ComparisonOperator {
    EQUALS("="),
    MATCHES("=~"),
    LIKE("=~", new CaseInsensitiveLikePropertyValueTransformer()),
    GREATER_THAN(">"),
    GREATER_THAN_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_EQUAL("<="),
    IS_NULL("IS NULL"),
    STARTING_WITH("STARTS WITH"),
    ENDING_WITH("ENDS WITH"),
    CONTAINING("CONTAINS"),
    IN("IN"),
    EXISTS("EXISTS"),
    IS_TRUE("=");

    private final String value;
    private final PropertyValueTransformer valueTransformer;

    private ComparisonOperator(String value) {
        this(value, new NoOpPropertyValueTransformer());
    }

    private ComparisonOperator(String value, PropertyValueTransformer propertyValueTransformer) {
        this.value = value;
        this.valueTransformer = propertyValueTransformer;
    }

    PropertyComparison compare(Object possiblePropertyValue) {
        if (possiblePropertyValue == null && !EnumSet.of(EXISTS, IS_TRUE, IS_NULL).contains((Object)this)) {
            throw new RuntimeException("A null possiblePropertyValue can only be used with unary comparison operators (EXISTS, IS_TRUE and IS_NULL)");
        }
        return new PropertyComparison(this, possiblePropertyValue);
    }

    public String getValue() {
        return this.value;
    }

    public PropertyValueTransformer getPropertyValueTransformer() {
        return this.valueTransformer;
    }
}

