/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.support.ClassUtils;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.typeconversion.EnumStringConverter;

public class MapCompositeConverter
implements CompositeAttributeConverter<Map<?, ?>> {
    private static final Set<Class> castableTypes = Stream.of(Short.class, Short.TYPE, Integer.class, Integer.TYPE, Float.class, Float.class).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private final String delimiter;
    private final boolean allowCast;
    private final ParameterizedType mapFieldType;
    private final String propertyLookup;
    private final Predicate<Class<?>> isSupportedNativeType;
    private BiFunction<Properties.Phase, String, String> enumKeysTransformation = new Properties.NoopTransformation();
    private final Map<Class<? extends Enum<?>>, EnumStringConverter> converterCache = new ConcurrentHashMap();

    public MapCompositeConverter(String prefix, String delimiter, boolean allowCast, ParameterizedType mapFieldType, Predicate<Class<?>> isSupportedNativeType) {
        this.delimiter = delimiter;
        this.allowCast = allowCast;
        this.mapFieldType = mapFieldType;
        this.propertyLookup = prefix + delimiter;
        this.isSupportedNativeType = isSupportedNativeType;
    }

    public void setEnumKeysTransformation(BiFunction<Properties.Phase, String, String> enumKeysTransformation) {
        this.enumKeysTransformation = enumKeysTransformation;
    }

    @Override
    public Map<String, ?> toGraphProperties(Map<?, ?> fieldValue) {
        if (fieldValue == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> graphProperties = new HashMap<String, Object>(fieldValue.size());
        this.addMapToProperties(fieldValue, graphProperties, this.propertyLookup);
        return graphProperties;
    }

    private void addMapToProperties(Map<?, ?> fieldValue, Map<String, Object> graphProperties, String entryPrefix) {
        for (Map.Entry<?, ?> entry : fieldValue.entrySet()) {
            Object entryValue = entry.getValue();
            String entryKey = entryPrefix + this.keyInstanceToString(entry.getKey());
            if (entryValue instanceof Map) {
                this.addMapToProperties((Map)entryValue, graphProperties, entryKey + this.delimiter);
                continue;
            }
            if (this.isCypherType(entryValue) || this.allowCast && this.canCastType(entryValue)) {
                graphProperties.put(entryKey, entryValue);
                continue;
            }
            if (ClassUtils.isEnum(entryValue)) {
                EnumStringConverter enumStringConverter = this.converterCache.computeIfAbsent(entryValue.getClass(), EnumStringConverter::new);
                graphProperties.put(entryKey, enumStringConverter.toGraphProperty((Enum)entryValue));
                continue;
            }
            if (Set.class.isAssignableFrom(entryValue.getClass())) {
                graphProperties.put(entryKey, new ArrayList((Set)entryValue));
                continue;
            }
            throw new MappingException("Could not map key=" + entryPrefix + entry.getKey() + ", value=" + entryValue + " (type = " + entryValue.getClass() + ") because it is not a supported type.");
        }
    }

    private boolean canCastType(Object value) {
        return castableTypes.contains(value.getClass());
    }

    private boolean isCypherType(Object entryValue) {
        return entryValue == null || this.isSupportedNativeType.test(entryValue.getClass());
    }

    @Override
    public Map<?, ?> toEntityAttribute(Map<String, ?> value) {
        Set prefixedProperties = value.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.propertyLookup)).collect(Collectors.toSet());
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry entry2 : prefixedProperties) {
            String propertyKey = ((String)entry2.getKey()).substring(this.propertyLookup.length());
            this.putToMap(result, propertyKey, entry2.getValue(), this.mapFieldType);
        }
        return result;
    }

    private void putToMap(Map<Object, Object> result, String propertyKey, Object value, Type fieldType) {
        if (propertyKey.contains(this.delimiter)) {
            int delimiterIndex = propertyKey.indexOf(this.delimiter);
            String key = propertyKey.substring(0, delimiterIndex);
            Object keyInstance = this.keyInstanceFromString(key, this.getKeyType(fieldType));
            HashMap<Object, Object> o = (HashMap<Object, Object>)result.get(key);
            if (o == null) {
                o = new HashMap<Object, Object>();
                result.put(keyInstance, o);
            }
            this.putToMap(o, propertyKey.substring(delimiterIndex + this.delimiter.length()), value, this.nestedMapFieldType(fieldType));
        } else {
            Object keyInstance = this.keyInstanceFromString(propertyKey, this.getKeyType(fieldType));
            Type valueType = this.nestedMapFieldType(fieldType);
            if (valueType != null) {
                if (value instanceof String && ClassUtils.isEnum((Type)valueType)) {
                    EnumStringConverter enumStringConverter = this.converterCache.computeIfAbsent((Class)valueType, EnumStringConverter::new);
                    value = enumStringConverter.toEntityAttribute((String)((Object)value));
                } else if (valueType instanceof ParameterizedType) {
                    value = Utils.coerceTypes((Class)this.nestedCollectionFieldType(valueType), value);
                    Class rawCollectionType = (Class)((ParameterizedType)valueType).getRawType();
                    if (SortedSet.class.isAssignableFrom(rawCollectionType)) {
                        value = new TreeSet(value);
                    } else if (Set.class.isAssignableFrom(rawCollectionType)) {
                        value = new HashSet(value);
                    }
                } else {
                    value = Utils.coerceTypes((Class)valueType, value);
                }
            }
            result.put(keyInstance, value);
        }
    }

    private Class<?> getKeyType(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)fieldType).getActualTypeArguments()[0];
        }
        return null;
    }

    private Type nestedMapFieldType(Type keyType) {
        if (keyType instanceof ParameterizedType) {
            return ((ParameterizedType)keyType).getActualTypeArguments()[1];
        }
        return null;
    }

    private Type nestedCollectionFieldType(Type keyType) {
        if (keyType instanceof ParameterizedType) {
            return ((ParameterizedType)keyType).getActualTypeArguments()[0];
        }
        return null;
    }

    private String keyInstanceToString(Object propertyKey) {
        if (propertyKey == null) {
            throw new UnsupportedOperationException("Null is not a supported property key!");
        }
        if (propertyKey instanceof String) {
            return (String)propertyKey;
        }
        if (ClassUtils.isEnum((Object)propertyKey)) {
            return this.enumKeysTransformation.apply(Properties.Phase.TO_GRAPH, ((Enum)propertyKey).name());
        }
        throw new UnsupportedOperationException("Only String and Enum allowed to be keys, got " + propertyKey.getClass());
    }

    private Object keyInstanceFromString(String propertyKey, Class<?> keyType) {
        if (keyType == null) {
            return propertyKey;
        }
        if (keyType.equals(String.class)) {
            return propertyKey;
        }
        if (ClassUtils.isEnum(keyType)) {
            Object key = Enum.valueOf(keyType, this.enumKeysTransformation.apply(Properties.Phase.TO_ENTITY, propertyKey));
            return key;
        }
        throw new UnsupportedOperationException("Only String and Enum allowed to be keys, got " + keyType);
    }

    public String getPropertyLookup() {
        return this.propertyLookup;
    }
}

