/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

class NestedPathMatchClause
implements MatchClause {
    private int index;
    private StringBuilder clause;

    NestedPathMatchClause(int index) {
        this(index, "n");
    }

    NestedPathMatchClause(int index, String varName) {
        this.index = index;
        this.clause = new StringBuilder("MATCH (").append(varName).append(")");
    }

    @Override
    public MatchClause append(Filter filter) {
        boolean wasPreviousSegmentRelationshipEntity = false;
        for (Filter.NestedPathSegment segment : filter.getNestedPath()) {
            boolean nestedRelationshipEntity = segment.isNestedRelationshipEntity();
            if (!wasPreviousSegmentRelationshipEntity) {
                if (segment.getRelationshipDirection() == Relationship.Direction.INCOMING) {
                    this.clause.append("<");
                }
                this.clause.append(String.format("-[%s:`%s`]-", nestedRelationshipEntity && this.isLastSegment(filter, segment) ? "r" + this.index : "", segment.getRelationshipType()));
                if (segment.getRelationshipDirection() == Relationship.Direction.OUTGOING) {
                    this.clause.append(">");
                }
            }
            if (!nestedRelationshipEntity && !this.isLastSegment(filter, segment)) {
                this.clause.append(String.format("(:`%s`)", segment.getNestedEntityTypeLabel()));
            }
            wasPreviousSegmentRelationshipEntity = nestedRelationshipEntity;
        }
        this.clause.append(String.format("(%s) ", "m" + this.index));
        return this;
    }

    private boolean isLastSegment(Filter filter, Filter.NestedPathSegment segment) {
        return filter.getNestedPath().indexOf(segment) == filter.getNestedPath().size() - 1;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }
}

