/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.context.GraphRowModelMapper;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.SessionDelegate;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadOneDelegate
extends SessionDelegate {
    private static final Logger logger = LoggerFactory.getLogger(LoadOneDelegate.class);

    public LoadOneDelegate(Neo4jSession session) {
        super(session);
    }

    public <T, ID extends Serializable> T load(Class<T> type, ID id) {
        return this.load(type, id, 1);
    }

    public <T, ID extends Serializable> T load(Class<T> type, ID id, int depth) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo == null) {
            throw new IllegalArgumentException(type + " is not a managed entity.");
        }
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (!(primaryIndexField == null || primaryIndexField.isTypeOf(id.getClass()) || primaryIndexField.type().isPrimitive() && id.getClass().toString().toLowerCase(Locale.ROOT).contains(primaryIndexField.type().getName()))) {
            throw new IllegalArgumentException("Supplied id does not match primary index type on supplied class " + type.getName());
        }
        if (primaryIndexField == null && !(id instanceof Long)) {
            throw new IllegalArgumentException("Supplied id must be of type Long (native graph id) when supplied class does not have primary id " + type.getName());
        }
        Optional<String> labelsOrType = this.session.determineLabelsOrTypeForLoading(type);
        if (!labelsOrType.isPresent()) {
            logger.warn("Unable to find database label for entity " + type.getName() + " : no results will be returned. Make sure the class is registered, and not abstract without @NodeEntity annotation");
            return null;
        }
        QueryStatements<ID> queryStatements = this.session.queryStatementsFor(type, depth);
        PagingAndSortingQuery qry = queryStatements.findOneByType(labelsOrType.get(), this.convertIfNeeded(classInfo, id), depth);
        DefaultGraphModelRequest request = new DefaultGraphModelRequest(qry.getStatement(), qry.getParameters());
        return (T)this.session.doInTransaction(() -> {
            try (Response response = this.session.requestHandler().execute(request);){
                new GraphRowModelMapper(this.session.metaData(), this.session.context(), this.session.getEntityInstantiator()).map(type, (Response<GraphModel>)response);
                Object t = this.lookup(type, id);
                return t;
            }
        }, Transaction.Type.READ_ONLY);
    }

    private <T, U> T lookup(Class<T> type, U id) {
        ClassInfo typeInfo = this.session.metaData().classInfo(type.getName());
        FieldInfo primaryIndex = typeInfo.primaryIndexField();
        Object ref = typeInfo.annotationsInfo().get(RelationshipEntity.class) == null ? (primaryIndex == null ? this.session.context().getNodeEntity((Long)id) : this.session.context().getNodeEntityById(typeInfo, id)) : (primaryIndex == null ? this.session.context().getRelationshipEntity((Long)id) : this.session.context().getRelationshipEntityById(typeInfo, id));
        try {
            return type.cast(ref);
        }
        catch (ClassCastException cce) {
            logger.warn("Could not cast entity {} for id {} to {}", new Object[]{ref, id, type});
            return null;
        }
    }
}

