/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.FilterWithRelationship;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.NoOpPropertyValueTransformer;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;
import org.neo4j.ogm.support.CollectionUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class Filter
implements FilterWithRelationship {
    private int index = 0;
    private String propertyName;
    private BooleanOperator booleanOperator = BooleanOperator.NONE;
    private boolean negated;
    private Class<?> ownerEntityType;
    private String nestedEntityTypeLabel;
    private String nestedPropertyName;
    private Class<?> nestedPropertyType;
    private String relationshipType;
    private Relationship.Direction relationshipDirection;
    private AttributeConverter propertyConverter;
    private boolean nestedRelationshipEntity;
    private FilterFunction<?> function;
    private List<NestedPathSegment> nestedPath;

    public Filter(FilterFunction function) {
        this(null, function);
    }

    public Filter(DistanceComparison distanceComparisonFunction, ComparisonOperator comparisonOperator) {
        this(null, distanceComparisonFunction.withOperator(comparisonOperator));
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator, Object propertyValue) {
        this(propertyName, comparisonOperator.compare(propertyValue));
    }

    public Filter(String propertyName, FilterFunction filterFunction) {
        this.propertyName = propertyName;
        this.function = filterFunction;
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator) {
        this(propertyName, comparisonOperator.compare(null));
    }

    public static void setNameFromProperty(Filter filter, String propertyName) {
        filter.propertyName = propertyName;
    }

    public Relationship.Direction getRelationshipDirection() {
        return this.relationshipDirection;
    }

    @Override
    public void setRelationshipDirection(Relationship.Direction relationshipDirection) {
        this.relationshipDirection = relationshipDirection;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public Filters and(Filter filter) {
        filter.setBooleanOperator(BooleanOperator.AND);
        return new Filters(this, filter);
    }

    public Filters or(Filter filter) {
        filter.setBooleanOperator(BooleanOperator.OR);
        return new Filters(this, filter);
    }

    public Filter ignoreCase() {
        if (!(this.function instanceof PropertyComparison)) {
            throw new IllegalStateException("ignoreCase is only supported for a filter based on property comparison");
        }
        PropertyComparison propertyComparision = (PropertyComparison)this.function;
        if (!EnumSet.of(ComparisonOperator.EQUALS, ComparisonOperator.CONTAINING, ComparisonOperator.STARTING_WITH, ComparisonOperator.ENDING_WITH).contains((Object)propertyComparision.getOperator())) {
            throw new IllegalStateException(String.format("ignoreCase is only supported for %s or %s comparison", ComparisonOperator.EQUALS.name(), ComparisonOperator.CONTAINING.name()));
        }
        this.function = new PropertyComparison.CaseInsensitiveEqualsComparison(propertyComparision.getOperator(), propertyComparision.getValue());
        return this;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public Class<?> getOwnerEntityType() {
        return this.ownerEntityType;
    }

    public void setOwnerEntityType(Class<?> ownerEntityType) {
        this.ownerEntityType = ownerEntityType;
    }

    public String getNestedPropertyName() {
        return this.nestedPropertyName;
    }

    public void setNestedPropertyName(String nestedPropertyName) {
        this.nestedPropertyName = nestedPropertyName;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Override
    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.nestedPropertyName != null;
    }

    public Class<?> getNestedPropertyType() {
        return this.nestedPropertyType;
    }

    public void setNestedPropertyType(Class<?> nestedPropertyType) {
        this.nestedPropertyType = nestedPropertyType;
    }

    public String getNestedEntityTypeLabel() {
        return this.nestedEntityTypeLabel;
    }

    public void setNestedEntityTypeLabel(String nestedEntityTypeLabel) {
        this.nestedEntityTypeLabel = nestedEntityTypeLabel;
    }

    public void setNestedPath(NestedPathSegment ... path) {
        this.nestedPath = new ArrayList<NestedPathSegment>(Arrays.asList(path));
    }

    public List<NestedPathSegment> getNestedPath() {
        return this.nestedPath;
    }

    public boolean isDeepNested() {
        return this.getNestedPath() != null && !this.getNestedPath().isEmpty();
    }

    public boolean isNestedRelationshipEntity() {
        return this.nestedRelationshipEntity;
    }

    public void setNestedRelationshipEntity(boolean nestedRelationshipEntity) {
        this.nestedRelationshipEntity = nestedRelationshipEntity;
    }

    private String uniqueParameterName(String originalName) {
        Object format = "%2$d";
        if (this.isNested()) {
            format = this.getNestedPropertyName() + "_" + this.getPropertyName() + "_" + (String)format;
        } else if (this.getPropertyName() != null) {
            format = this.getPropertyName() + "_" + (String)format;
        }
        return String.format((String)format, originalName, this.index);
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    public void setPropertyConverter(AttributeConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String toCypher(String nodeIdentifier, boolean addWhereClause) {
        String fragment = this.function.expression(nodeIdentifier, this.propertyName, this::uniqueParameterName);
        String suffix = this.isNegated() ? this.negate(fragment) : fragment;
        return this.cypherPrefix(addWhereClause) + suffix;
    }

    public Map<String, Object> parameters() {
        AttributeConverter applicablePropertyConverter = this.getPropertyConverter();
        PropertyValueTransformer valueTransformer = applicablePropertyConverter == null ? new NoOpPropertyValueTransformer() : value -> {
            List convertedValues = StreamSupport.stream(CollectionUtils.iterableOf((Object)value).spliterator(), false).map(applicablePropertyConverter::toGraphProperty).collect(Collectors.toList());
            if (convertedValues.size() == 1) {
                return convertedValues.get(0);
            }
            return convertedValues;
        };
        return this.function.parameters(this::uniqueParameterName, valueTransformer);
    }

    private String cypherPrefix(boolean addWhereClause) {
        StringBuilder cypher = new StringBuilder();
        if (addWhereClause) {
            cypher.append("WHERE ");
        } else if (!this.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
            cypher.append(this.getBooleanOperator().getValue()).append(" ");
        }
        return cypher.toString();
    }

    private String negate(String expression) {
        return String.format("NOT(%s) ", expression);
    }

    public static class NestedPathSegment
    implements FilterWithRelationship {
        private final String propertyName;
        private final Class propertyType;
        private String relationshipType;
        private Relationship.Direction relationshipDirection;
        private String nestedEntityTypeLabel;
        private boolean nestedRelationshipEntity;

        public NestedPathSegment(String propertyName, Class propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public String getRelationshipType() {
            return this.relationshipType;
        }

        @Override
        public void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public void setRelationshipDirection(Relationship.Direction relationshipDirection) {
            this.relationshipDirection = relationshipDirection;
        }

        public Relationship.Direction getRelationshipDirection() {
            return this.relationshipDirection;
        }

        public void setNestedEntityTypeLabel(String nestedEntityTypeLabel) {
            this.nestedEntityTypeLabel = nestedEntityTypeLabel;
        }

        public String getNestedEntityTypeLabel() {
            return this.nestedEntityTypeLabel;
        }

        public void setNestedRelationshipEntity(boolean nestedRelationshipEntity) {
            this.nestedRelationshipEntity = nestedRelationshipEntity;
        }

        public boolean isNestedRelationshipEntity() {
            return this.nestedRelationshipEntity;
        }
    }
}

