/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

public class Pagination {
    private final Integer index;
    private final Integer size;
    private Integer offset;

    public Pagination(int pageNumber, int pageSize) {
        if (pageNumber < 0) {
            throw new RuntimeException("Page number must not be negative");
        }
        if (pageSize < 1) {
            throw new RuntimeException("Page size must greater then zero");
        }
        this.index = pageNumber;
        this.size = pageSize;
    }

    public void setOffset(Integer offset) {
        if (offset < 0) {
            throw new RuntimeException("Offset must greater then zero");
        }
        this.offset = offset;
    }

    public String toString() {
        if (this.offset != null) {
            return " SKIP " + this.offset + " LIMIT " + this.size;
        }
        return " SKIP " + this.index * this.size + " LIMIT " + this.size;
    }
}

