/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.EntityInstantiator;

public class ReflectionEntityInstantiator
implements EntityInstantiator {
    private final MetaData metadata;

    public ReflectionEntityInstantiator(MetaData metadata) {
        this.metadata = metadata;
    }

    @Override
    public <T> T createInstance(Class<T> clazz, Map<String, Object> propertyValues) {
        try {
            Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new MappingException("Unable to find default constructor to instantiate " + clazz, e);
        }
    }

    @Override
    public <T> T createInstanceWithConstructorArgs(Class<T> clazz, Map<String, Object> propertyValues) {
        try {
            ClassInfo classInfo = this.metadata.classInfo(clazz);
            Constructor<T> instantiatingConstructor = this.determineConstructor(clazz, propertyValues);
            instantiatingConstructor.setAccessible(true);
            Parameter[] parameters = instantiatingConstructor.getParameters();
            if (parameters.length == 0) {
                return instantiatingConstructor.newInstance(new Object[0]);
            }
            Object[] values = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Object value;
                Parameter parameter = parameters[i];
                String parameterName = parameter.getName();
                FieldInfo fieldInfo = classInfo.getFieldInfo(parameterName);
                values[i] = value = fieldInfo.convert(propertyValues.get(parameterName));
                propertyValues.remove(parameterName);
            }
            return instantiatingConstructor.newInstance(values);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new MappingException("Unable to find default constructor to instantiate " + clazz, e);
        }
    }

    private <T> Constructor<T> determineConstructor(Class<T> clazz, Map<String, Object> propertyValue) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> instantiatingConstructorCandidate = null;
        Set<String> availableProperties = propertyValue.keySet();
        int parameterMatchCount = -1;
        for (Constructor<?> constructor : constructors) {
            List<String> constructorParameterNames;
            int intersectionAmount;
            Parameter[] constructorParameters = constructor.getParameters();
            if (constructorParameters.length < parameterMatchCount || (intersectionAmount = this.calculateIntersectionAmount(constructorParameterNames = Arrays.stream(constructorParameters).map(Parameter::getName).toList(), availableProperties)) <= parameterMatchCount) continue;
            instantiatingConstructorCandidate = constructor;
            parameterMatchCount = intersectionAmount;
        }
        return instantiatingConstructorCandidate;
    }

    private int calculateIntersectionAmount(Collection<String> constructorParameterNames, Collection<String> availableProperties) {
        HashSet<String> availablePropertiesCopy = new HashSet<String>(availableProperties);
        int existingPropertiesAmount = availablePropertiesCopy.size();
        availablePropertiesCopy.removeAll(constructorParameterNames);
        int leftOverPropertiesAmount = availablePropertiesCopy.size();
        return existingPropertiesAmount - leftOverPropertiesAmount;
    }
}

