/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.PostLoad;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.Required;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.exception.core.InvalidPropertyFieldException;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.AnnotationsInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.FieldsInfo;
import org.neo4j.ogm.metadata.InterfacesInfo;
import org.neo4j.ogm.metadata.KotlinDetector;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.MethodsInfo;
import org.neo4j.ogm.support.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private final List<ClassInfo> directSubclasses = new ArrayList<ClassInfo>();
    private volatile Set<ClassInfo> allSubclasses;
    private final List<ClassInfo> directInterfaces = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directImplementingClasses = new ArrayList<ClassInfo>();
    private final List<ClassInfo> indirectSuperClasses = new ArrayList<ClassInfo>();
    private final String className;
    private final boolean isInterface;
    private final boolean isAbstract;
    private final boolean isEnum;
    private ClassInfo directSuperclass;
    private String directSuperclassName;
    private String neo4jName;
    private final FieldsInfo fieldsInfo;
    private final MethodsInfo methodsInfo;
    private final AnnotationsInfo annotationsInfo;
    private final InterfacesInfo interfacesInfo;
    private final Class<?> cls;
    private final Map<Class, List<FieldInfo>> iterableFieldsForType = new HashMap<Class, List<FieldInfo>>();
    private final Map<FieldInfo, Field> fieldInfoFields = new ConcurrentHashMap<FieldInfo, Field>();
    private volatile Map<String, FieldInfo> propertyFields;
    private volatile Map<String, FieldInfo> indexFields;
    private volatile Collection<FieldInfo> requiredFields;
    private volatile Optional<FieldInfo> identityField;
    private volatile Optional<FieldInfo> versionField;
    private volatile Optional<FieldInfo> primaryIndexField;
    private volatile FieldInfo labelField = null;
    private volatile boolean labelFieldMapped = false;
    private volatile Optional<MethodInfo> postLoadMethod;
    private volatile Collection<String> staticLabels;
    private volatile Set<FieldInfo> relationshipFields;
    private volatile Optional<FieldInfo> endNodeReader;
    private volatile Optional<FieldInfo> startNodeReader;
    private Class<? extends IdStrategy> idStrategyClass;
    private IdStrategy idStrategy;

    public ClassInfo(Class<?> cls, TypeSystem typeSystem) {
        this(cls, null, typeSystem);
    }

    private ClassInfo(Class<?> cls, Field parent, TypeSystem typeSystem) {
        this.cls = cls;
        int modifiers = cls.getModifiers();
        this.isInterface = Modifier.isInterface(modifiers);
        this.isAbstract = Modifier.isAbstract(modifiers);
        this.isEnum = ClassUtils.isEnum(cls);
        this.className = cls.getName();
        if (cls.getSuperclass() != null) {
            this.directSuperclassName = cls.getSuperclass().getName();
        }
        this.interfacesInfo = new InterfacesInfo(cls);
        this.fieldsInfo = new FieldsInfo(this, cls, parent, typeSystem);
        this.methodsInfo = new MethodsInfo(cls, parent);
        this.annotationsInfo = new AnnotationsInfo(cls);
        if (this.isRelationshipEntity() && this.labelFieldOrNull() != null) {
            throw new MappingException(String.format("'%s' is a relationship entity. The @Labels annotation can't be applied to relationship entities.", this.name()));
        }
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.hasAnnotation(Property.class) || !fieldInfo.hasCompositeConverter()) continue;
            throw new MappingException(String.format("'%s' has both @Convert and @Property annotations applied to the field '%s'", this.name(), fieldInfo.getName()));
        }
        if (KotlinDetector.isKotlinType(cls)) {
            this.inspectLocalDelegates(typeSystem);
        }
    }

    private void inspectLocalDelegates(TypeSystem typeSystem) {
        for (Field field : this.cls.getDeclaredFields()) {
            if (!ClassInfo.isKotlinDelegate(field)) continue;
            ClassInfo indirectSuperClass = new ClassInfo(field.getType(), field, typeSystem);
            this.extend(indirectSuperClass);
            this.indirectSuperClasses.add(indirectSuperClass);
        }
    }

    private static boolean isKotlinDelegate(Field field) {
        return field.isSynthetic() && field.getName().startsWith("$$delegate_");
    }

    void extend(ClassInfo classInfo) {
        this.interfacesInfo.append(classInfo.interfacesInfo());
        this.fieldsInfo.append(classInfo.fieldsInfo());
        this.methodsInfo.append(classInfo.methodsInfo());
    }

    void addSubclass(ClassInfo subclass) {
        if (subclass.directSuperclass != null && subclass.directSuperclass != this) {
            throw new RuntimeException(subclass.className + " has two superclasses: " + subclass.directSuperclass.className + ", " + this.className);
        }
        subclass.directSuperclass = this;
        this.directSubclasses.add(subclass);
    }

    public String name() {
        return this.className;
    }

    String simpleName() {
        return ClassInfo.deriveSimpleName(this.cls);
    }

    public static String deriveSimpleName(Class<?> clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public ClassInfo directSuperclass() {
        return this.directSuperclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> staticLabels() {
        Collection<String> knownStaticLabels = this.staticLabels;
        if (knownStaticLabels == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                knownStaticLabels = this.staticLabels;
                if (knownStaticLabels == null) {
                    knownStaticLabels = this.staticLabels = Collections.unmodifiableCollection(this.collectLabels());
                }
            }
        }
        return knownStaticLabels;
    }

    public String neo4jName() {
        if (this.neo4jName == null) {
            AnnotationInfo annotationInfo = this.annotationsInfo.get(NodeEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("label", this.simpleName());
                return this.neo4jName;
            }
            annotationInfo = this.annotationsInfo.get(RelationshipEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("type", this.simpleName().toUpperCase());
                return this.neo4jName;
            }
            if (!this.isAbstract) {
                this.neo4jName = this.simpleName();
            }
        }
        return this.neo4jName;
    }

    private Collection<String> collectLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        if (!this.isAbstract || this.annotationsInfo.get(NodeEntity.class) != null) {
            labels.add(this.neo4jName());
        }
        if (this.directSuperclass != null && !"java.lang.Object".equals(this.directSuperclass.className)) {
            labels.addAll(this.directSuperclass.collectLabels());
        }
        for (ClassInfo interfaceInfo : this.directInterfaces()) {
            labels.addAll(interfaceInfo.collectLabels());
        }
        for (ClassInfo indirectSuperClass : this.indirectSuperClasses) {
            labels.addAll(indirectSuperClass.collectLabels());
        }
        return labels;
    }

    public List<ClassInfo> directSubclasses() {
        return this.directSubclasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClassInfo> allSubclasses() {
        Set<ClassInfo> computedSubclasses = this.allSubclasses;
        if (computedSubclasses == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                computedSubclasses = this.allSubclasses;
                if (computedSubclasses == null) {
                    computedSubclasses = this.allSubclasses = this.computeSubclasses();
                }
            }
        }
        return computedSubclasses;
    }

    private Set<ClassInfo> computeSubclasses() {
        HashSet<ClassInfo> computedSubclasses = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.directSubclasses()) {
            computedSubclasses.add(classInfo);
            computedSubclasses.addAll(classInfo.allSubclasses());
        }
        for (ClassInfo classInfo : this.directImplementingClasses()) {
            computedSubclasses.add(classInfo);
            computedSubclasses.addAll(classInfo.allSubclasses());
        }
        return Collections.unmodifiableSet(computedSubclasses);
    }

    List<ClassInfo> directImplementingClasses() {
        return this.directImplementingClasses;
    }

    List<ClassInfo> directInterfaces() {
        return this.directInterfaces;
    }

    InterfacesInfo interfacesInfo() {
        return this.interfacesInfo;
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotationsInfo.list();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public AnnotationsInfo annotationsInfo() {
        return this.annotationsInfo;
    }

    String superclassName() {
        return this.directSuperclassName;
    }

    public FieldsInfo fieldsInfo() {
        return this.fieldsInfo;
    }

    MethodsInfo methodsInfo() {
        return this.methodsInfo;
    }

    public FieldInfo identityFieldOrNull() {
        return this.getOrComputeIdentityField().orElse(null);
    }

    public FieldInfo identityField() {
        return this.getOrComputeIdentityField().orElseThrow(() -> new MetadataException("No internal identity field found for class: " + this.className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<FieldInfo> getOrComputeIdentityField() {
        Optional<FieldInfo> result = this.identityField;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.identityField;
                if (result == null) {
                    Collection<FieldInfo> identityFields = this.getFieldInfos(FieldInfo::isInternalIdentity);
                    if (identityFields.size() == 1) {
                        this.identityField = Optional.of(identityFields.iterator().next());
                    } else {
                        if (identityFields.size() > 1) {
                            throw new MetadataException("Expected exactly one internal identity field (@Id with InternalIdStrategy), found " + identityFields.size() + " " + identityFields);
                        }
                        this.identityField = this.fieldsInfo.fields().stream().filter(f -> "id".equals(f.getName())).filter(f -> "java.lang.Long".equals(f.getTypeDescriptor())).findFirst();
                    }
                    result = this.identityField;
                }
            }
        }
        return result;
    }

    public boolean hasIdentityField() {
        return this.getOrComputeIdentityField().isPresent();
    }

    Collection<FieldInfo> getFieldInfos(Predicate<FieldInfo> predicate) {
        return this.fieldsInfo().fields().stream().filter(predicate).collect(Collectors.toSet());
    }

    public FieldInfo labelFieldOrNull() {
        if (this.labelFieldMapped) {
            return this.labelField;
        }
        if (!this.labelFieldMapped) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (!fieldInfo.isLabelField()) continue;
                if (!fieldInfo.isIterable()) {
                    throw new MappingException(String.format("Field '%s' in class '%s' includes the @Labels annotation, however this field is not a type of collection.", fieldInfo.getName(), this.name()));
                }
                this.labelFieldMapped = true;
                this.labelField = fieldInfo;
                return this.labelField;
            }
            this.labelFieldMapped = true;
        }
        return null;
    }

    public boolean isRelationshipEntity() {
        for (AnnotationInfo info : this.annotations()) {
            if (!info.getName().equals(RelationshipEntity.class.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<FieldInfo> propertyFields() {
        return this.getOrComputePropertyFields().values();
    }

    public FieldInfo propertyField(String propertyName) {
        return propertyName == null ? null : this.getOrComputePropertyFields().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FieldInfo> getOrComputePropertyFields() {
        Map<String, FieldInfo> result = this.propertyFields;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.propertyFields;
                if (result == null) {
                    Collection<FieldInfo> fields = this.fieldsInfo().fields();
                    FieldInfo optionalIdentityField = this.identityFieldOrNull();
                    HashMap<String, FieldInfo> intermediateFieldMap = new HashMap<String, FieldInfo>(fields.size());
                    for (FieldInfo fieldInfo : fields) {
                        if (fieldInfo == optionalIdentityField || fieldInfo.isLabelField() || fieldInfo.hasAnnotation(StartNode.class) || fieldInfo.hasAnnotation(EndNode.class)) continue;
                        if (!fieldInfo.getAnnotations().has(Property.class)) {
                            if (!fieldInfo.persistableAsProperty()) continue;
                            intermediateFieldMap.put(fieldInfo.property(), fieldInfo);
                            continue;
                        }
                        if (fieldInfo.persistableAsProperty()) {
                            intermediateFieldMap.put(fieldInfo.property(), fieldInfo);
                            continue;
                        }
                        throw new InvalidPropertyFieldException(fieldInfo);
                    }
                    result = this.propertyFields = Collections.unmodifiableMap(intermediateFieldMap);
                }
            }
        }
        return result;
    }

    public FieldInfo propertyFieldByName(String propertyName) {
        for (FieldInfo fieldInfo : this.propertyFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(propertyName)) continue;
            return fieldInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FieldInfo> relationshipFields() {
        Set<FieldInfo> result = this.relationshipFields;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.relationshipFields;
                if (result == null) {
                    FieldInfo optionalIdentityField = this.identityFieldOrNull();
                    HashSet<FieldInfo> identifiedRelationshipFields = new HashSet<FieldInfo>();
                    for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                        if (fieldInfo == optionalIdentityField) continue;
                        if (fieldInfo.getAnnotations().has(Relationship.class)) {
                            identifiedRelationshipFields.add(fieldInfo);
                            continue;
                        }
                        if (fieldInfo.persistableAsProperty()) continue;
                        identifiedRelationshipFields.add(fieldInfo);
                    }
                    result = this.relationshipFields = Collections.unmodifiableSet(identifiedRelationshipFields);
                }
            }
        }
        return result;
    }

    public FieldInfo relationshipField(String relationshipName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public FieldInfo relationshipField(String relationshipName, Relationship.Direction relationshipDirection, boolean strict) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            Relationship.Direction declaredDirection;
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || !ClassInfo.isActualDirectionCompatibleWithDeclaredDirection(relationshipDirection, declaredDirection = fieldInfo.relationshipDirectionOrDefault(Relationship.Direction.OUTGOING))) continue;
            return fieldInfo;
        }
        return null;
    }

    public Set<FieldInfo> candidateRelationshipFields(String relationshipName, Relationship.Direction relationshipDirection, boolean strict) {
        HashSet<FieldInfo> candidateFields = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            Relationship.Direction declaredDirection;
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || !ClassInfo.isActualDirectionCompatibleWithDeclaredDirection(relationshipDirection, declaredDirection = fieldInfo.relationshipDirectionOrDefault(Relationship.Direction.OUTGOING))) continue;
            candidateFields.add(fieldInfo);
        }
        return candidateFields;
    }

    public FieldInfo relationshipFieldByName(String fieldName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(fieldName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Field getField(FieldInfo fieldInfo) {
        Field field = this.fieldInfoFields.get(fieldInfo);
        if (field != null) {
            return field;
        }
        try {
            field = this.cls.getDeclaredField(fieldInfo.getName());
            this.fieldInfoFields.put(fieldInfo, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.directSuperclass() != null) {
                field = this.directSuperclass().getField(fieldInfo);
                this.fieldInfoFields.put(fieldInfo, field);
                return field;
            }
            throw new RuntimeException("Field " + fieldInfo.getName() + " not found in class " + this.name() + " or any of its superclasses");
        }
    }

    public List<FieldInfo> findFields(Class<?> fieldType) {
        String fieldSignature = fieldType.getName();
        Predicate<FieldInfo> matchesType = f -> f.getTypeDescriptor().equals(fieldSignature);
        return this.fieldsInfo().fields().stream().filter(matchesType).collect(Collectors.toList());
    }

    public List<FieldInfo> findFields(String annotation) {
        Predicate<FieldInfo> hasAnnotation = f -> f.hasAnnotation(annotation);
        return this.fieldsInfo().fields().stream().filter(hasAnnotation).collect(Collectors.toList());
    }

    public List<FieldInfo> findIterableFields() {
        Predicate<FieldInfo> isIterable = f -> {
            Class<?> type = this.getField((FieldInfo)f).getType();
            return type.isArray() || Iterable.class.isAssignableFrom(type);
        };
        try {
            return this.fieldsInfo().fields().stream().filter(isIterable).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType) {
        if (this.iterableFieldsForType.containsKey(iteratedType)) {
            return this.iterableFieldsForType.get(iteratedType);
        }
        String typeSignature = iteratedType.getName();
        String arrayOfTypeSignature = typeSignature + "[]";
        Predicate<FieldInfo> isIterableOfType = f -> {
            String fieldType = f.getTypeDescriptor();
            boolean isMatchingArray = f.isArray() && (fieldType.equals(arrayOfTypeSignature) || f.isParameterisedTypeOf(iteratedType));
            boolean isMatchingIterable = f.isIterable() && (fieldType.equals(typeSignature) || f.isParameterisedTypeOf(iteratedType));
            return isMatchingArray || isMatchingIterable;
        };
        return this.fieldsInfo().fields().stream().filter(isIterableOfType).collect(Collectors.toList());
    }

    public List<FieldInfo> findIterableFields(Class<?> iteratedType, String relationshipType, Relationship.Direction relationshipDirection, boolean strict) {
        ArrayList<FieldInfo> iterableFields = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.findIterableFields(iteratedType)) {
            Relationship.Direction declaredDirection;
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipType.equals(relationship) || !ClassInfo.isActualDirectionCompatibleWithDeclaredDirection(relationshipDirection, declaredDirection = fieldInfo.relationshipDirectionOrDefault(Relationship.Direction.OUTGOING))) continue;
            iterableFields.add(fieldInfo);
        }
        return iterableFields;
    }

    private static boolean isActualDirectionCompatibleWithDeclaredDirection(Relationship.Direction actual, Relationship.Direction declared) {
        return (declared == Relationship.Direction.INCOMING || declared == Relationship.Direction.UNDIRECTED) && actual == Relationship.Direction.INCOMING || declared != Relationship.Direction.INCOMING && actual == Relationship.Direction.OUTGOING;
    }

    public boolean isTransient() {
        return this.annotationsInfo.get(Transient.class) != null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    boolean isSubclassOf(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        if (this == classInfo) {
            return true;
        }
        for (ClassInfo subclass : classInfo.directSubclasses()) {
            if (!this.isSubclassOf(subclass)) continue;
            return true;
        }
        return this.indirectSuperClasses.stream().anyMatch(c -> c.getUnderlyingClass() == classInfo.getUnderlyingClass());
    }

    public Class<?> getUnderlyingClass() {
        return this.cls;
    }

    Class<?> getTypeParameterDescriptorForRelationship(String relationshipType, Relationship.Direction relationshipDirection) {
        boolean STRICT_MODE = true;
        boolean INFERRED_MODE = false;
        try {
            FieldInfo fieldInfo = this.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && fieldInfo.getTypeDescriptor() != null) {
                return DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
            }
            if (relationshipDirection != Relationship.Direction.INCOMING && (fieldInfo = this.relationshipField(relationshipType, relationshipDirection, false)) != null && fieldInfo.getTypeDescriptor() != null) {
                return DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Could not get {} class type for relationshipType {} and relationshipDirection {} ", new Object[]{this.className, relationshipType, relationshipDirection});
        }
        return null;
    }

    public boolean containsIndexes() {
        return !this.getIndexFields().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FieldInfo> getIndexFields() {
        Map<String, FieldInfo> result = this.indexFields;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.indexFields;
                if (result == null) {
                    HashMap<String, FieldInfo> indexes = new HashMap<String, FieldInfo>();
                    Field[] declaredFields = this.cls.getDeclaredFields();
                    for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                        if (!ClassInfo.isDeclaredField(declaredFields, fieldInfo.getName()) || !fieldInfo.hasAnnotation(Id.class)) continue;
                        String propertyValue = fieldInfo.property();
                        if (fieldInfo.hasAnnotation(Property.class.getName())) {
                            propertyValue = fieldInfo.property();
                        }
                        indexes.put(propertyValue, fieldInfo);
                    }
                    result = this.indexFields = Collections.unmodifiableMap(indexes);
                }
            }
        }
        return result.values();
    }

    private static boolean isDeclaredField(Field[] declaredFields, String name) {
        for (Field field : declaredFields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public FieldInfo primaryIndexField() {
        return this.getOrComputePrimaryIndexField().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<FieldInfo> getOrComputePrimaryIndexField() {
        Optional<FieldInfo> result = this.primaryIndexField;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.primaryIndexField;
                if (result == null) {
                    Optional<FieldInfo> potentialPrimaryIndexField = Optional.empty();
                    Collection<FieldInfo> primaryIndexFields = this.getFieldInfos(this::isPrimaryIndexField);
                    if (primaryIndexFields.size() > 1) {
                        throw new MetadataException("Only one @Id / @Index(primary=true, unique=true) annotation is allowed in a class hierarchy. Please check annotations in the class " + this.name() + " or its parents");
                    }
                    if (!primaryIndexFields.isEmpty()) {
                        FieldInfo selectedField = primaryIndexFields.iterator().next();
                        AnnotationInfo generatedValueAnnotation = selectedField.getAnnotations().get(GeneratedValue.class);
                        if (generatedValueAnnotation != null) {
                            GeneratedValue value = (GeneratedValue)generatedValueAnnotation.getAnnotation();
                            this.idStrategyClass = value.strategy();
                            try {
                                this.idStrategy = this.idStrategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                LOGGER.debug("Could not instantiate {}. Expecting this to be registered manually.", this.idStrategyClass);
                            }
                        }
                        potentialPrimaryIndexField = Optional.of(selectedField);
                    }
                    result = this.validateIdGenerationConfigFor(potentialPrimaryIndexField);
                }
            }
        }
        return result;
    }

    private Optional<FieldInfo> validateIdGenerationConfigFor(Optional<FieldInfo> potentialPrimaryIndexField) {
        this.fieldsInfo().fields().forEach(info -> {
            if (info.hasAnnotation(GeneratedValue.class) && !info.hasAnnotation(Id.class)) {
                throw new MetadataException("The type of @Generated field in class " + this.className + " must be also annotated with @Id.");
            }
        });
        if (UuidStrategy.class.equals(this.idStrategyClass)) {
            potentialPrimaryIndexField.ifPresent(selectedField -> {
                if (!selectedField.isTypeOf(UUID.class) && !selectedField.isTypeOf(String.class)) {
                    throw new MetadataException("The type of " + selectedField.getName() + " in class " + this.className + " must be of type java.lang.UUID or java.lang.String because it has an UUID generation strategy.");
                }
            });
        }
        return potentialPrimaryIndexField;
    }

    public boolean hasPrimaryIndexField() {
        return this.getOrComputePrimaryIndexField().isPresent();
    }

    private boolean isPrimaryIndexField(FieldInfo fieldInfo) {
        boolean hasIdAnnotation = fieldInfo.hasAnnotation(Id.class);
        boolean hasStrategyOtherThanInternal = !fieldInfo.hasAnnotation(GeneratedValue.class) || !((GeneratedValue)fieldInfo.getAnnotations().get(GeneratedValue.class).getAnnotation()).strategy().equals(InternalIdStrategy.class);
        return hasIdAnnotation && hasStrategyOtherThanInternal;
    }

    public IdStrategy idStrategy() {
        return this.getOrComputePrimaryIndexField().map(ignored -> this.idStrategy).orElse(null);
    }

    public Class<? extends IdStrategy> idStrategyClass() {
        return this.idStrategyClass;
    }

    public void registerIdGenerationStrategy(IdStrategy strategy) {
        if (!strategy.getClass().equals(this.idStrategyClass)) {
            throw new IllegalArgumentException("Strategy " + strategy + " is not an instance of " + this.idStrategyClass);
        }
        this.idStrategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo postLoadMethodOrNull() {
        Optional<MethodInfo> result = this.postLoadMethod;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.postLoadMethod;
                if (result == null) {
                    Collection<MethodInfo> possiblePostLoadMethods = this.methodsInfo.findMethodInfoBy(methodInfo -> methodInfo.hasAnnotation(PostLoad.class));
                    if (possiblePostLoadMethods.size() > 1) {
                        throw new MetadataException(String.format("Cannot have more than one post load method annotated with @PostLoad for class '%s'", this.className));
                    }
                    result = this.postLoadMethod = possiblePostLoadMethods.stream().findFirst();
                }
            }
        }
        return result.orElse(null);
    }

    public FieldInfo getFieldInfo(String propertyName) {
        FieldInfo optionalLabelField = this.labelFieldOrNull();
        if (optionalLabelField != null && optionalLabelField.getName().equals(propertyName)) {
            return optionalLabelField;
        }
        FieldInfo propertyField = this.propertyField(propertyName);
        if (propertyField != null) {
            return propertyField;
        }
        return this.fieldsInfo.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getEndNodeReader() {
        Optional<FieldInfo> result = this.endNodeReader;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.endNodeReader;
                if (result == null) {
                    if (this.isRelationshipEntity()) {
                        this.endNodeReader = this.fieldsInfo().fields().stream().filter(fieldInfo -> fieldInfo.getAnnotations().get(EndNode.class) != null).findFirst();
                        if (!this.endNodeReader.isPresent()) {
                            LOGGER.warn("Failed to find an @EndNode on {}", (Object)this.name());
                        }
                    } else {
                        this.endNodeReader = Optional.empty();
                    }
                    result = this.endNodeReader;
                }
            }
        }
        return result.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getStartNodeReader() {
        Optional<FieldInfo> result = this.startNodeReader;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.startNodeReader;
                if (result == null) {
                    if (this.isRelationshipEntity()) {
                        this.startNodeReader = this.fieldsInfo().fields().stream().filter(fieldInfo -> fieldInfo.getAnnotations().get(StartNode.class) != null).findFirst();
                        if (!this.startNodeReader.isPresent()) {
                            LOGGER.warn("Failed to find an @StartNode on {}", (Object)this.name());
                        }
                    } else {
                        this.startNodeReader = Optional.empty();
                    }
                    result = this.startNodeReader;
                }
            }
        }
        return result.orElse(null);
    }

    public boolean hasRequiredFields() {
        return !this.requiredFields().isEmpty();
    }

    public Collection<FieldInfo> requiredFields() {
        if (this.requiredFields == null) {
            this.requiredFields = new ArrayList<FieldInfo>();
            for (FieldInfo fieldInfo : this.propertyFields()) {
                if (!fieldInfo.getAnnotations().has(Required.class)) continue;
                this.requiredFields.add(fieldInfo);
            }
        }
        return this.requiredFields;
    }

    public boolean hasVersionField() {
        return this.getOrComputeVersionField().isPresent();
    }

    public FieldInfo getVersionField() {
        return this.getOrComputeVersionField().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<FieldInfo> getOrComputeVersionField() {
        Optional<FieldInfo> result = this.versionField;
        if (result == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                result = this.versionField;
                if (result == null) {
                    Collection<FieldInfo> fields = this.getFieldInfos(FieldInfo::isVersionField);
                    if (fields.size() > 1) {
                        throw new MetadataException("Only one version field is allowed, found " + fields);
                    }
                    Iterator<FieldInfo> iterator = fields.iterator();
                    this.versionField = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
                    result = this.versionField;
                }
            }
        }
        return result;
    }

    public Object readPrimaryIndexValueOf(Object entity) {
        Objects.requireNonNull(entity, "Entity to read from must not be null.");
        Object value = null;
        if (this.hasPrimaryIndexField()) {
            value = this.primaryIndexField().read(entity);
        }
        return value;
    }

    public Function<Object, Optional<Object>> getPrimaryIndexOrIdReader() {
        Function<Object, Optional<Object>> reader = this.hasPrimaryIndexField() ? t -> Optional.ofNullable(this.readPrimaryIndexValueOf(t)) : t -> Optional.ofNullable(this.identityField().read(t));
        return reader;
    }

    static Object getInstanceOrDelegate(Object instance, Field delegateHolder) {
        if (delegateHolder == null) {
            return instance;
        }
        return AccessController.doPrivileged(() -> {
            try {
                delegateHolder.setAccessible(true);
                return delegateHolder.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String toString() {
        return "ClassInfo{className='" + this.className + "', neo4jName='" + this.neo4jName + "'}";
    }
}

