/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collections;
import java.util.Map;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.session.Neo4jSession;

public class DtoMapper {
    private final Neo4jSession session;
    private final ReflectionEntityInstantiator instantiator;

    public DtoMapper(Neo4jSession session) {
        this.session = session;
        this.instantiator = new ReflectionEntityInstantiator(session.metaData());
    }

    public <T> T newInstance(Class<T> type, Map<String, Object> properties) {
        T object = this.instantiator.createInstanceWithConstructorArgs(type, properties);
        this.setProperties(properties, object);
        return object;
    }

    private void setProperties(Map<String, Object> properties, Object instance) {
        ClassInfo classInfo = this.session.metaData().classInfo(instance);
        properties.forEach((s, o) -> this.writeProperty(classInfo, instance, (String)s, o));
    }

    private void writeProperty(ClassInfo classInfo, Object instance, String propertyName, Object value) {
        FieldInfo writer = classInfo.getFieldInfo(propertyName);
        if (writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) {
            Class<?> paramType = writer.type();
            Class<?> elementType = this.underlyingElementType(classInfo, propertyName);
            value = paramType.isArray() ? EntityAccessManager.merge(paramType, value, new Object[0], elementType) : EntityAccessManager.merge(paramType, value, Collections.emptyList(), elementType);
        }
        writer.write(instance, value);
    }

    private Class<?> underlyingElementType(ClassInfo classInfo, String propertyName) {
        FieldInfo fieldInfo = this.fieldInfoForPropertyName(propertyName, classInfo);
        Class<?> clazz = null;
        if (fieldInfo != null) {
            clazz = DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
        }
        return clazz;
    }

    private FieldInfo fieldInfoForPropertyName(String propertyName, ClassInfo classInfo) {
        FieldInfo labelField = classInfo.labelFieldOrNull();
        if (labelField != null && labelField.getName().equalsIgnoreCase(propertyName)) {
            return labelField;
        }
        return classInfo.propertyField(propertyName);
    }
}

