/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class DeletedRelationshipStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Edge> deletedEdges;

    public DeletedRelationshipStatementBuilder(Set<Edge> deletedEdges, StatementFactory statementFactory) {
        this.deletedEdges = deletedEdges;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap parameters = new HashMap();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.deletedEdges != null && this.deletedEdges.size() > 0) {
            Edge firstEdge = this.deletedEdges.iterator().next();
            queryBuilder.append("UNWIND $rows as row ").append("MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode ").append("MATCH (endNode) WHERE ID(endNode) = row.endNodeId ").append("MATCH (startNode)-[rel:`").append(firstEdge.getType()).append("`]->(endNode) ").append("DELETE rel");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.deletedEdges) {
                HashMap<String, Long> rowMap = new HashMap<String, Long>();
                rowMap.put("startNodeId", edge.getStartNode());
                rowMap.put("endNodeId", edge.getEndNode());
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

