/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.OptimisticLockingUtils;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.PropertyContainer;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class DeletedRelationshipEntityStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Edge> deletedEdges;

    public DeletedRelationshipEntityStatementBuilder(Set<Edge> deletedEdges, StatementFactory statementFactory) {
        this.deletedEdges = deletedEdges;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.deletedEdges != null && this.deletedEdges.size() > 0) {
            Edge firstEdge = this.deletedEdges.iterator().next();
            queryBuilder.append("UNWIND $rows AS row MATCH ()-[r]->() WHERE ID(r) = row.relId ");
            if (firstEdge.hasVersionProperty()) {
                queryBuilder.append(OptimisticLockingUtils.getFragmentForExistingNodesAndRelationships((PropertyContainer)firstEdge, "r"));
            }
            queryBuilder.append("DELETE r RETURN ID(r) as ref, ID(r) as id, $type as type");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.deletedEdges) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("relId", edge.getId());
                if (edge.hasVersionProperty()) {
                    Property version = edge.getVersion();
                    rowMap.put((String)version.getKey(), version.getValue());
                }
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
            parameters.put("type", "rel");
            if (firstEdge.hasVersionProperty()) {
                OptimisticLockingConfig olConfig = new OptimisticLockingConfig(rows.size(), new String[]{firstEdge.getType()}, (String)firstEdge.getVersion().getKey());
                return this.statementFactory.statement(queryBuilder.toString(), parameters, olConfig);
            }
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

