/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.annotation.typeconversion.DateLong;
import org.neo4j.ogm.annotation.typeconversion.DateString;
import org.neo4j.ogm.annotation.typeconversion.EnumString;
import org.neo4j.ogm.annotation.typeconversion.NumberString;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.typeconversion.DateLongConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;
import org.neo4j.ogm.typeconversion.EnumStringConverter;
import org.neo4j.ogm.typeconversion.InstantLongConverter;
import org.neo4j.ogm.typeconversion.NumberStringConverter;

public class ObjectAnnotations {
    private final Map<String, AnnotationInfo> annotations;

    static ObjectAnnotations of(Annotation ... annotations) {
        Map<String, AnnotationInfo> annotationInfo = Arrays.stream(annotations).map(AnnotationInfo::new).collect(Collectors.toMap(AnnotationInfo::getName, Function.identity()));
        return new ObjectAnnotations(annotationInfo);
    }

    private ObjectAnnotations(Map<String, AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    public AnnotationInfo get(String key) {
        return this.annotations.get(key);
    }

    public AnnotationInfo get(Class<?> keyClass) {
        return keyClass == null ? null : this.annotations.get(keyClass.getName());
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    Object getConverter(Class<?> fieldType) {
        AnnotationInfo customType = this.get(Convert.class);
        if (customType != null) {
            String classDescriptor = customType.get("value", null);
            if (classDescriptor == null || Convert.Unset.class.getName().equals(classDescriptor)) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(classDescriptor, false, Configuration.OGM_CLASS_LOADER);
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AnnotationInfo dateLongConverterInfo = this.get(DateLong.class);
        if (dateLongConverterInfo != null) {
            if (fieldType.equals(Instant.class)) {
                return new InstantLongConverter();
            }
            return new DateLongConverter();
        }
        AnnotationInfo dateStringConverterInfo = this.get(DateString.class);
        if (dateStringConverterInfo != null) {
            String format = dateStringConverterInfo.get("value", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            return new DateStringConverter(format, this.isLenientConversion(dateStringConverterInfo));
        }
        AnnotationInfo enumStringConverterInfo = this.get(EnumString.class);
        if (enumStringConverterInfo != null) {
            String classDescriptor = enumStringConverterInfo.get("value", null);
            try {
                Class<?> clazz = Class.forName(classDescriptor, false, Configuration.OGM_CLASS_LOADER);
                return new EnumStringConverter(clazz, this.isLenientConversion(enumStringConverterInfo));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AnnotationInfo numberStringConverterInfo = this.get(NumberString.class);
        if (numberStringConverterInfo != null) {
            String classDescriptor = numberStringConverterInfo.get("value", null);
            try {
                Class<?> clazz = Class.forName(classDescriptor, false, Configuration.OGM_CLASS_LOADER);
                return new NumberStringConverter(clazz, this.isLenientConversion(numberStringConverterInfo));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean isLenientConversion(AnnotationInfo converterInfo) {
        String lenientConversionKey = "lenient";
        return Boolean.parseBoolean(converterInfo.get(lenientConversionKey));
    }

    public boolean has(Class<?> clazz) {
        return this.annotations.containsKey(clazz.getName());
    }
}

