/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.support.ClassUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.AttributeConverters;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ConversionCallbackRegistry;
import org.neo4j.ogm.typeconversion.ConvertibleTypes;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainInfo.class);
    private final TypeSystem typeSystem;
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private Map<String, List<ClassInfo>> nodeEntitiesByLabel;
    private Map<String, List<ClassInfo>> relationshipEntitiesByType;
    private final Map<String, List<ClassInfo>> interfaceNameToClassInfo = new HashMap<String, List<ClassInfo>>();
    private final Set<Class> enumTypes = new HashSet<Class>();
    private final ConversionCallbackRegistry conversionCallbackRegistry = new ConversionCallbackRegistry();

    public DomainInfo(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    public static DomainInfo create(String ... packages) {
        return DomainInfo.create((TypeSystem)TypeSystem.NoNativeTypes.INSTANCE, packages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainInfo create(TypeSystem typeSystem, String ... packages) {
        DomainInfo domainInfo = new DomainInfo(typeSystem);
        Predicate<Class> classIsMappable = clazz -> !clazz.isAnnotation() && !clazz.isAnonymousClass() && !clazz.equals(Object.class);
        try (ScanResult scanResult = DomainInfo.findClasses(packages);){
            for (String className : scanResult.getAllClasses().getNames()) {
                try {
                    Class<?> clazz2 = Class.forName(className, false, Configuration.OGM_CLASS_LOADER);
                    if (!classIsMappable.test(clazz2)) continue;
                    domainInfo.addClass(clazz2);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Could not load class {}", (Object)className);
                }
            }
        }
        finally {
            domainInfo.finish();
        }
        return domainInfo;
    }

    private static ScanResult findClasses(String[] packagesOrClasses) {
        return new ClassGraph().ignoreClassVisibility().whitelistPackages(packagesOrClasses).whitelistClasses(packagesOrClasses).scan();
    }

    private void addClass(Class clazz) {
        ClassInfo classInfo = this.classNameToClassInfo.computeIfAbsent(clazz.getName(), k -> new ClassInfo(clazz, this.typeSystem));
        String superclassName = classInfo.superclassName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing: {} -> {}", (Object)classInfo.name(), (Object)superclassName);
        }
        if (classInfo.isEnum()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering enum class: {}", (Object)classInfo.name());
            }
            this.enumTypes.add(classInfo.getUnderlyingClass());
        }
        if (superclassName != null) {
            ClassInfo superclassInfo = this.classNameToClassInfo.get(superclassName);
            if (superclassInfo != null) {
                superclassInfo.addSubclass(classInfo);
            } else if (!"java.lang.Object".equals(superclassName) && !"java.lang.Enum".equals(superclassName)) {
                ClassInfo superClassInfo = new ClassInfo(clazz.getSuperclass(), this.typeSystem);
                superClassInfo.addSubclass(classInfo);
                this.classNameToClassInfo.put(superclassName, superClassInfo);
            }
        }
    }

    private void buildByLabelLookupMaps() {
        LOGGER.info("Building byLabel lookup maps");
        HashMap<String, List> temporaryNodeEntitiesByLabel = new HashMap<String, List>();
        HashMap<String, List> temporaryRelationshipEntitiesByType = new HashMap<String, List>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            AnnotationInfo relationshipEntityAnnotation;
            AnnotationInfo nodeEntityAnnotation = classInfo.annotationsInfo().get(NodeEntity.class);
            if (nodeEntityAnnotation != null) {
                List classInfos = temporaryNodeEntitiesByLabel.computeIfAbsent(classInfo.neo4jName(), k -> new ArrayList());
                classInfos.add(classInfo);
            }
            if ((relationshipEntityAnnotation = classInfo.annotationsInfo().get(RelationshipEntity.class)) == null) continue;
            List classInfos = temporaryRelationshipEntitiesByType.computeIfAbsent(classInfo.neo4jName(), k -> new ArrayList());
            classInfos.add(classInfo);
        }
        this.nodeEntitiesByLabel = Collections.unmodifiableMap(temporaryNodeEntitiesByLabel);
        this.relationshipEntitiesByType = Collections.unmodifiableMap(temporaryRelationshipEntitiesByType);
    }

    private void buildInterfaceNameToClassInfoMap() {
        LOGGER.info("Building interface class map for {} classes", (Object)this.classNameToClassInfo.values().size());
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            LOGGER.debug(" - {} implements {} interfaces", (Object)classInfo.simpleName(), (Object)classInfo.interfacesInfo().list().size());
            for (InterfaceInfo iface : classInfo.interfacesInfo().list()) {
                LOGGER.debug("   - {}", (Object)iface.name());
                List classInfoList = this.interfaceNameToClassInfo.computeIfAbsent(iface.name(), key -> new ArrayList());
                classInfoList.add(classInfo);
            }
        }
    }

    void registerConversionCallback(ConversionCallback conversionCallback) {
        this.conversionCallbackRegistry.registerConversionCallback(conversionCallback);
    }

    private void finish() {
        LOGGER.info("Starting Post-processing phase");
        this.buildByLabelLookupMaps();
        this.buildInterfaceNameToClassInfoMap();
        ArrayList<ClassInfo> transientClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.name() == null || classInfo.name().equals("java.lang.Object")) continue;
            LOGGER.debug("Post-processing: {}", (Object)classInfo.name());
            if (classInfo.isTransient()) {
                LOGGER.debug(" - Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
                continue;
            }
            if (classInfo.superclassName() == null || classInfo.superclassName().equals("java.lang.Object")) {
                this.extend(classInfo, classInfo.directSubclasses());
            }
            for (InterfaceInfo interfaceInfo : classInfo.interfacesInfo().list()) {
                this.implement(classInfo, interfaceInfo);
            }
        }
        LOGGER.debug("Checking for @Transient classes....");
        Collection<List<ClassInfo>> interfaceInfos = this.interfaceNameToClassInfo.values();
        for (List<ClassInfo> list : interfaceInfos) {
            for (ClassInfo classInfo : list) {
                if (!classInfo.isTransient()) continue;
                LOGGER.debug("Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
            }
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        for (ClassInfo classInfo : transientClasses) {
            hashSet.addAll(this.removeTransientClass(classInfo));
        }
        LOGGER.debug("Registering converters and deregistering transient fields and methods....");
        this.postProcessFields(hashSet);
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            classInfo.primaryIndexField();
            classInfo.getVersionField();
        }
        LOGGER.info("Post-processing complete");
    }

    private void postProcessFields(Set<Class> transientClassesRemoved) {
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            boolean registerConverters = false;
            if (!classInfo.isEnum() && !classInfo.isInterface()) {
                registerConverters = true;
            }
            Iterator<FieldInfo> fieldInfoIterator = classInfo.fieldsInfo().fields().iterator();
            while (fieldInfoIterator.hasNext()) {
                FieldInfo fieldInfo = fieldInfoIterator.next();
                if (!fieldInfo.persistableAsProperty()) {
                    Class<?> fieldClass = null;
                    try {
                        fieldClass = DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Unable to compute class type for " + classInfo.name() + ", field: " + fieldInfo.getName());
                    }
                    if (fieldClass != null && transientClassesRemoved.contains(fieldClass)) {
                        fieldInfoIterator.remove();
                        continue;
                    }
                }
                if (!registerConverters) continue;
                this.registerDefaultFieldConverters(classInfo, fieldInfo);
            }
        }
    }

    private Set<Class> removeTransientClass(ClassInfo transientClass) {
        HashSet<Class> removed = new HashSet<Class>();
        if (transientClass != null && !transientClass.name().equals("java.lang.Object")) {
            LOGGER.debug("Removing @Transient class: {}", (Object)transientClass.name());
            this.classNameToClassInfo.remove(transientClass.name());
            removed.add(transientClass.getUnderlyingClass());
            for (ClassInfo transientChild : transientClass.directSubclasses()) {
                this.removeTransientClass(transientChild);
            }
            for (ClassInfo transientChild : transientClass.directImplementingClasses()) {
                this.removeTransientClass(transientChild);
            }
        }
        return removed;
    }

    private void extend(ClassInfo superclass, List<ClassInfo> subclasses) {
        for (ClassInfo subclass : subclasses) {
            subclass.extend(superclass);
            this.extend(subclass, subclass.directSubclasses());
        }
    }

    private void implement(ClassInfo implementingClass, InterfaceInfo interfaceInfo) {
        ClassInfo interfaceClass = this.classNameToClassInfo.get(interfaceInfo.name());
        if (interfaceClass != null) {
            if (!implementingClass.directInterfaces().contains(interfaceClass)) {
                LOGGER.debug(" - Setting {} implements {}", (Object)implementingClass.simpleName(), (Object)interfaceClass.simpleName());
                implementingClass.directInterfaces().add(interfaceClass);
            }
            if (!interfaceClass.directImplementingClasses().contains(implementingClass)) {
                interfaceClass.directImplementingClasses().add(implementingClass);
            }
            for (ClassInfo subClassInfo : implementingClass.directSubclasses()) {
                this.implement(subClassInfo, interfaceInfo);
            }
        } else {
            LOGGER.debug(" - No ClassInfo found for interface class: {}", (Object)interfaceInfo.name());
        }
    }

    public ClassInfo getClass(String fqn) {
        return this.classNameToClassInfo.get(fqn);
    }

    ClassInfo getClassSimpleName(String fullOrPartialClassName) {
        return this.getClassInfo(fullOrPartialClassName, this.classNameToClassInfo);
    }

    private ClassInfo getClassInfo(String fullOrPartialClassName, Map<String, ClassInfo> infos) {
        if (infos.containsKey(fullOrPartialClassName)) {
            return infos.get(fullOrPartialClassName);
        }
        Pattern partialClassNamePattern = Pattern.compile(".+[\\\\.\\$]" + Pattern.quote(fullOrPartialClassName) + "$");
        List foundKeys = infos.keySet().stream().filter(partialClassNamePattern.asPredicate()).collect(Collectors.toList());
        if (foundKeys.isEmpty()) {
            return null;
        }
        if (foundKeys.size() > 1) {
            throw new MappingException("More than one class has simple name: " + fullOrPartialClassName);
        }
        return infos.get(foundKeys.get(0));
    }

    Map<String, List<ClassInfo>> getNodeEntitiesByLabel() {
        return this.nodeEntitiesByLabel;
    }

    Map<String, List<ClassInfo>> getRelationshipEntitiesByType() {
        return this.relationshipEntitiesByType;
    }

    private void registerDefaultFieldConverters(ClassInfo classInfo, FieldInfo fieldInfo) {
        if (!fieldInfo.hasPropertyConverter() && !fieldInfo.hasCompositeConverter()) {
            String typeDescriptor = fieldInfo.getTypeDescriptor();
            Function<AttributeConverters, Optional> selectAttributeConverter = ac -> DomainInfo.selectAttributeConverterFor(fieldInfo, ac);
            Optional registeredAttributeConverter = ConvertibleTypes.REGISTRY.entrySet().stream().filter(e -> typeDescriptor.contains((CharSequence)e.getKey())).sorted(Comparator.comparingInt(e -> ((String)e.getKey()).length()).reversed()).findFirst().map(Map.Entry::getValue).flatMap(selectAttributeConverter);
            boolean isSupportedNativeType = this.typeSystem.supportsAsNativeType(DescriptorMappings.getType(fieldInfo.getTypeDescriptor()));
            if (registeredAttributeConverter.isPresent() && !isSupportedNativeType) {
                fieldInfo.setPropertyConverter((AttributeConverter)registeredAttributeConverter.get());
            } else {
                Class<?> fieldType;
                if (fieldInfo.getAnnotations().get(Convert.class) != null) {
                    Class<?> entityAttributeType = DescriptorMappings.getType(typeDescriptor);
                    String graphTypeDescriptor = fieldInfo.getAnnotations().get(Convert.class).get("graphPropertyType", null);
                    if (graphTypeDescriptor == null) {
                        throw new MappingException("Found annotation to convert a " + (entityAttributeType != null ? entityAttributeType.getName() : " null object ") + " on " + classInfo.name() + '.' + fieldInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                    }
                    fieldInfo.setPropertyConverter(new ProxyAttributeConverter(entityAttributeType, DescriptorMappings.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
                }
                if ((fieldType = DescriptorMappings.getType(typeDescriptor)) == null) {
                    throw new RuntimeException("Class " + classInfo.name() + " field " + fieldInfo.getName() + " has null field type.");
                }
                boolean enumConverterSet = false;
                for (Class enumClass : this.enumTypes) {
                    if (!fieldType.equals(enumClass)) continue;
                    DomainInfo.setEnumFieldConverter(fieldInfo, enumClass);
                    enumConverterSet = true;
                    break;
                }
                if (!enumConverterSet && ClassUtils.isEnum(fieldType)) {
                    LOGGER.debug("Setting default enum converter for unscanned class " + classInfo.name() + ", field: " + fieldInfo.getName());
                    DomainInfo.setEnumFieldConverter(fieldInfo, fieldType);
                }
            }
        }
    }

    public Map<String, ClassInfo> getClassInfoMap() {
        return this.classNameToClassInfo;
    }

    public List<ClassInfo> getClassInfos(String interfaceName) {
        return this.interfaceNameToClassInfo.get(interfaceName);
    }

    private static Optional<AttributeConverter<?, ?>> selectAttributeConverterFor(FieldInfo source, AttributeConverters from) {
        FieldInfo fieldInfo = Objects.requireNonNull(source, "Need a field info");
        AttributeConverters attributeConverters = Objects.requireNonNull(from, "Need the set of attribute converters for the given field info.");
        AttributeConverter<?, ?> selectedConverter = fieldInfo.isArray() ? attributeConverters.forArray : (fieldInfo.isIterable() ? attributeConverters.forIterable.apply(fieldInfo.getCollectionClassname()) : attributeConverters.forScalar);
        return Optional.ofNullable(selectedConverter);
    }

    private static void setEnumFieldConverter(FieldInfo fieldInfo, Class enumClass) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }
}

