/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.support.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(SingleUseEntityMapper.class);
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityFactory entityFactory) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData);
    }

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityInstantiator entityInstantiator) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData, entityInstantiator);
    }

    public <T> T map(Class<T> type, String[] columnNames, RowModel rowModel) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < rowModel.getValues().length; ++i) {
            properties.put(columnNames[i], rowModel.getValues()[i]);
        }
        T entity = this.entityFactory.newObject(type, properties);
        this.setPropertiesOnEntity(entity, properties);
        return entity;
    }

    public <T> T map(Class<T> type, Map<String, Object> row) {
        T entity = this.entityFactory.newObject(type, row);
        this.setPropertiesOnEntity(entity, row);
        return entity;
    }

    private void setPropertiesOnEntity(Object entity, Map<String, Object> propertyMap) {
        ClassInfo classInfo = this.resolveClassInfoFor(entity.getClass());
        for (Map.Entry<String, Object> propertyMapEntry : propertyMap.entrySet()) {
            this.writeProperty(classInfo, entity, propertyMapEntry);
        }
    }

    private ClassInfo resolveClassInfoFor(Class<?> type) {
        ClassInfo classInfo = this.metadata.classInfo(type.getName());
        if (classInfo != null) {
            return classInfo;
        }
        throw new MappingException("Error mapping to ad-hoc " + type + ".  At present, only @Result types that are discovered by the domain entity package scanning can be mapped.");
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Map.Entry<String, Object> property) {
        FieldInfo fieldInfo;
        FieldInfo writer = classInfo.getFieldInfo(property.getKey());
        if (writer == null && (fieldInfo = classInfo.relationshipFieldByName(property.getKey())) != null) {
            writer = fieldInfo;
        }
        if (writer == null) {
            logger.warn("Unable to find property: {} on class: {} for writing", (Object)property.getKey(), (Object)classInfo.name());
        } else {
            Class<?> elementType = DescriptorMappings.getType(writer.getTypeDescriptor());
            boolean targetIsCollection = writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type());
            Object value = this.mapKnownNestedClasses(elementType, property.getKey(), property.getValue(), targetIsCollection);
            if (targetIsCollection) {
                if (value == null) {
                    value = Collections.emptyList();
                } else if (value.getClass().isArray()) {
                    value = Arrays.asList((Object[])value);
                }
                Class<?> paramType = writer.type();
                value = paramType.isArray() ? EntityAccessManager.merge(paramType, value, new Object[0], elementType) : EntityAccessManager.merge(paramType, value, Collections.emptyList(), elementType);
            }
            writer.write(instance, value);
        }
    }

    Object mapKnownNestedClasses(Class elementType, String property, Object value, boolean asCollection) {
        List<Object> mappedValue = value;
        if (this.metadata.classInfo(elementType) != null) {
            ArrayList nestedObjects = new ArrayList();
            for (Object nestedPropertyMap : this.iterableOf(value)) {
                if (nestedPropertyMap instanceof Map) {
                    nestedObjects.add(this.map(elementType, (Map)nestedPropertyMap));
                    continue;
                }
                if (elementType.isInstance(nestedPropertyMap) || ClassUtils.isEnum((Class)elementType)) {
                    nestedObjects.add(nestedPropertyMap);
                    continue;
                }
                logger.warn("Cannot map {} to a nested result object for property {}", nestedPropertyMap, (Object)property);
            }
            if (asCollection) {
                mappedValue = nestedObjects;
            } else if (nestedObjects.isEmpty()) {
                mappedValue = Collections.emptyList();
            } else if (nestedObjects.size() == 1) {
                mappedValue = nestedObjects.get(0);
            } else {
                logger.warn("Cannot map property {} from result set: The result contains more than one entry for the property.", (Object)property);
            }
        }
        return mappedValue;
    }

    Iterable iterableOf(Object thingToIterator) {
        if (thingToIterator == null) {
            return Collections.emptyList();
        }
        if (thingToIterator instanceof Iterable) {
            return (Iterable)thingToIterator;
        }
        if (thingToIterator.getClass().isArray()) {
            return Arrays.asList((Object[])thingToIterator);
        }
        return Collections.singletonList(thingToIterator);
    }
}

