/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.RestStatisticsModel;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.PropertyContainer;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.Utils;

public class RestModelMapper {
    private final MappingContext mappingContext;
    private final GraphEntityMapper delegate;

    public RestModelMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.mappingContext = mappingContext;
        this.delegate = new GraphEntityMapper(metaData, mappingContext, entityInstantiator);
    }

    public RestStatisticsModel map(Response<RestModel> response) {
        List resultRowBuilders = response.toList().stream().map((? super T model) -> {
            ResultRowBuilder resultRowBuilder = new ResultRowBuilder(this::getEntityOrNodeModel, this.mappingContext::getRelationshipEntity);
            model.getRow().forEach(resultRowBuilder::handle);
            return resultRowBuilder;
        }).collect(Collectors.toList());
        List<GraphModel> graphModels = resultRowBuilders.stream().map(ResultRowBuilder::buildGraphModel).collect(Collectors.toList());
        this.delegate.map(Object.class, graphModels);
        RestStatisticsModel restStatisticsModel = new RestStatisticsModel();
        response.getStatistics().ifPresent(restStatisticsModel::setStatistics);
        restStatisticsModel.setResult(resultRowBuilders.stream().map(ResultRowBuilder::finish).collect(Collectors.toList()));
        return restStatisticsModel;
    }

    private Object getEntityOrNodeModel(Long id, DefaultGraphModel graphModel) {
        return Optional.ofNullable(this.mappingContext.getNodeEntity(id)).orElseGet(() -> (Node)graphModel.findNode(id).orElseThrow(() -> new RuntimeException("Lost NodeModel for id " + id)));
    }

    static class ResultRowBuilder {
        private final List<NodeModel> nodeModels = new ArrayList<NodeModel>();
        private final Map<Long, RelationshipModel> relationshipModels = new LinkedHashMap<Long, RelationshipModel>();
        private DefaultGraphModel graphModel;
        private final BiFunction<Long, DefaultGraphModel, Object> resolveNodeId;
        private final Function<Long, Object> resolveRelationshipId;
        private Map<String, List<Long>> aliasToNodeIdMapping = new HashMap<String, List<Long>>();
        private Map<String, List<Long>> aliasToRelationshipIdMapping = new HashMap<String, List<Long>>();
        private Set<String> aliasesOfListResults = new HashSet<String>();
        private Map<String, Object> resultRow = new HashMap<String, Object>();

        ResultRowBuilder(BiFunction<Long, DefaultGraphModel, Object> resolveNodeId, Function<Long, Object> resolveRelationshipId) {
            this.resolveNodeId = resolveNodeId;
            this.resolveRelationshipId = id -> {
                Object result = resolveRelationshipId.apply((Long)id);
                if (result == null) {
                    return this.relationshipModels.get(id);
                }
                return result;
            };
        }

        void handle(String alias, Object resultObject) {
            if (!ResultRowBuilder.canBeMapped(resultObject)) {
                this.resultRow.put(alias, ResultRowBuilder.convertToTargetContainer(resultObject));
            } else if (resultObject instanceof List) {
                this.aliasesOfListResults.add(alias);
                ((List)resultObject).forEach(item -> this.addToGraphModel(alias, item));
            } else {
                this.addToGraphModel(alias, resultObject);
            }
        }

        private void addToGraphModel(String alias, Object item) {
            List ids;
            if (item instanceof NodeModel) {
                ids = this.aliasToNodeIdMapping.computeIfAbsent(alias, key -> new ArrayList());
                this.nodeModels.add((NodeModel)item);
            } else if (item instanceof RelationshipModel) {
                ids = this.aliasToRelationshipIdMapping.computeIfAbsent(alias, key -> new ArrayList());
                RelationshipModel relationshipModel = (RelationshipModel)item;
                this.relationshipModels.put(relationshipModel.getId(), relationshipModel);
            } else {
                throw new IllegalArgumentException(item + " is not a mappable object!");
            }
            ids.add(((PropertyContainer)item).getId());
        }

        DefaultGraphModel buildGraphModel() {
            if (this.graphModel != null) {
                throw new IllegalStateException("GraphModel already built!");
            }
            this.graphModel = new DefaultGraphModel();
            this.graphModel.addNodes(this.nodeModels.toArray(new NodeModel[0]));
            this.graphModel.addRelationships(this.relationshipModels.values().toArray(new RelationshipModel[0]));
            return this.graphModel;
        }

        Map<String, Object> finish() {
            if (this.graphModel == null) {
                throw new IllegalStateException("GraphModel not built yet!");
            }
            this.aliasToNodeIdMapping.forEach((k, v) -> {
                Object entity = !this.aliasesOfListResults.contains(k) && v.size() == 1 ? this.resolveNodeId.apply((Long)v.get(0), this.graphModel) : v.stream().map(id -> this.resolveNodeId.apply((Long)id, this.graphModel)).collect(Collectors.toList());
                this.resultRow.put((String)k, entity);
            });
            this.aliasToRelationshipIdMapping.forEach((k, v) -> {
                Object entity = !this.aliasesOfListResults.contains(k) && v.size() == 1 ? this.resolveRelationshipId.apply((Long)v.get(0)) : v.stream().map(this.resolveRelationshipId).collect(Collectors.toList());
                this.resultRow.put((String)k, entity);
            });
            return this.resultRow;
        }

        private static boolean canBeMapped(Object resultObject) {
            Predicate<Object> isNodeModel = NodeModel.class::isInstance;
            Predicate<Object> isRelationshipModel = RelationshipModel.class::isInstance;
            Predicate<Object> isNodeOrRelationshipModel = isNodeModel.or(isRelationshipModel);
            if (isNodeOrRelationshipModel.test(resultObject)) {
                return true;
            }
            if (resultObject instanceof List) {
                List listOfResultObjects = (List)resultObject;
                return listOfResultObjects.size() > 0 && listOfResultObjects.stream().allMatch(isNodeOrRelationshipModel);
            }
            return false;
        }

        private static Object convertToTargetContainer(Object resultObject) {
            Object array;
            if (!(resultObject instanceof List)) {
                return resultObject;
            }
            List entityList = (List)resultObject;
            Class<?> arrayClass = null;
            for (Object element : entityList) {
                Class<?> clazz = element.getClass();
                if (arrayClass == null) {
                    arrayClass = clazz;
                    continue;
                }
                if (arrayClass == clazz) continue;
                arrayClass = null;
                break;
            }
            if (arrayClass == null) {
                array = entityList.toArray();
            } else {
                array = Array.newInstance(arrayClass, entityList.size());
                for (int j = 0; j < entityList.size(); ++j) {
                    Array.set(array, j, Utils.coerceTypes(arrayClass, entityList.get(j)));
                }
            }
            return array;
        }
    }
}

