/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.SessionDelegate;
import org.neo4j.ogm.session.event.PostSaveEvent;
import org.neo4j.ogm.session.event.PreSaveEvent;
import org.neo4j.ogm.support.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SaveEventDelegate
extends SessionDelegate {
    private static final Logger logger = LoggerFactory.getLogger(SaveEventDelegate.class);
    private final Set<Object> visited = new HashSet<Object>();
    private final Map<Object, Boolean> preSaved = new HashMap<Object, Boolean>();
    private final Set<MappedRelationship> registeredRelationships;
    private final Set<MappedRelationship> addedRelationships;
    private final Set<MappedRelationship> deletedRelationships;

    SaveEventDelegate(Neo4jSession session) {
        super(session);
        this.registeredRelationships = new HashSet<MappedRelationship>(session.context().getRelationships());
        this.addedRelationships = new HashSet<MappedRelationship>();
        this.deletedRelationships = new HashSet<MappedRelationship>();
    }

    void preSave(Object object) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(object);
        while (!stack.isEmpty()) {
            Object cur = stack.pop();
            if (this.visited.contains(cur)) continue;
            this.visited.add(cur);
            if (this.dirty(cur)) {
                this.firePreSave(cur);
            }
            this.children(cur).forEach(stack::push);
        }
        for (Object other : this.unreachable()) {
            if (this.visited.contains(other) || this.preSaveFired(other)) continue;
            this.firePreSave(other);
            this.visited.add(other);
        }
        for (Object other : this.touched()) {
            if (this.preSaveFired(other)) continue;
            this.firePreSave(other);
        }
    }

    void postSave() {
        this.preSaved.entrySet().stream().map(e -> new PostSaveEvent(e.getKey(), (Boolean)e.getValue())).forEach(this.session::notifyListeners);
    }

    private void firePreSave(Object object) {
        boolean isNew = !this.session.context().optionalNativeId(object).isPresent();
        this.session.notifyListeners(new PreSaveEvent(object, isNew));
        this.preSaved.put(object, isNew);
    }

    private boolean preSaveFired(Object object) {
        return this.preSaved.containsKey(object);
    }

    private Set<Object> touched() {
        HashSet<Object> touched = new HashSet<Object>();
        for (MappedRelationship added : this.addedRelationships) {
            Object src = this.session.context().getNodeEntity(added.getStartNodeId());
            Object tgt = this.session.context().getNodeEntity(added.getEndNodeId());
            if (src != null) {
                touched.add(src);
            }
            if (tgt == null) continue;
            touched.add(tgt);
        }
        return touched;
    }

    private Set<Object> unreachable() {
        HashSet<Object> unreachable = new HashSet<Object>();
        for (MappedRelationship mappedRelationship : this.deletedRelationships) {
            logger.debug("unreachable start {} end {}", (Object)mappedRelationship.getStartNodeId(), (Object)mappedRelationship.getEndNodeId());
            this.addUnreachable(unreachable, mappedRelationship.getStartNodeId());
            this.addUnreachable(unreachable, mappedRelationship.getEndNodeId());
        }
        return unreachable;
    }

    private void addUnreachable(Set<Object> unreachable, long nodeId) {
        Object entity = this.session.context().getNodeEntity(nodeId);
        if (entity != null) {
            unreachable.add(entity);
        } else if (logger.isWarnEnabled()) {
            logger.warn("Relationship to/from entity id={} deleted, but entity is not in context - no events will be fired.", (Object)nodeId);
        }
    }

    private boolean dirty(Object parent) {
        if (this.session.context().isDirty(parent)) {
            logger.debug("dirty: {}", parent);
            return true;
        }
        ClassInfo parentInfo = this.session.metaData().classInfo(parent);
        long parentId = this.session.context().nativeId(parent);
        if (!parentInfo.isRelationshipEntity()) {
            for (FieldInfo reader : this.relationalReaders(parent)) {
                this.clearPreviousRelationships(parentId, reader);
                for (MappedRelationship mappable : this.map(parentInfo, parentId, reader.read(parent), reader)) {
                    if (this.isNew(mappable)) {
                        logger.debug("added new relationship: {} to {}", (Object)mappable, parent);
                        this.addedRelationships.add(mappable);
                        return true;
                    }
                    this.registeredRelationships.add(mappable);
                    this.deletedRelationships.remove(mappable);
                }
            }
            for (MappedRelationship previous : this.session.context().getRelationships()) {
                if (!this.isDeleted(previous) || previous.getStartNodeId() != parentId && previous.getEndNodeId() != parentId) continue;
                logger.debug("deleted: {} from {}", (Object)previous, parent);
                return true;
            }
        }
        return false;
    }

    private boolean isNew(MappedRelationship mappedRelationship) {
        return !this.session.context().getRelationships().contains(mappedRelationship);
    }

    private boolean isDeleted(MappedRelationship mappedRelationship) {
        return !this.registeredRelationships.contains(mappedRelationship);
    }

    private void clearPreviousRelationships(long parentId, FieldInfo reader) {
        String type = reader.relationshipType();
        Class<?> endNodeType = DescriptorMappings.getType(reader.getTypeDescriptor());
        if (reader.relationshipDirection().equals("INCOMING")) {
            this.deregisterIncomingRelationship(parentId, type, endNodeType);
        } else if (reader.relationshipDirection().equals("OUTGOING")) {
            this.deregisterOutgoingRelationship(parentId, type, endNodeType);
        } else {
            this.deregisterOutgoingRelationship(parentId, type, endNodeType);
            this.deregisterIncomingRelationship(parentId, type, endNodeType);
        }
    }

    private void deregisterIncomingRelationship(Long id, String relationshipType, Class endNodeType) {
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        while (iterator.hasNext()) {
            MappedRelationship mappedRelationship = iterator.next();
            if (mappedRelationship.getEndNodeId() != id.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getStartNodeType())) continue;
            this.deletedRelationships.add(mappedRelationship);
            iterator.remove();
        }
    }

    private void deregisterOutgoingRelationship(Long id, String relationshipType, Class endNodeType) {
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        while (iterator.hasNext()) {
            MappedRelationship mappedRelationship = iterator.next();
            if (mappedRelationship.getStartNodeId() != id.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getEndNodeType())) continue;
            this.deletedRelationships.add(mappedRelationship);
            iterator.remove();
        }
    }

    private List<Object> children(Object parent) {
        ArrayList<Object> children = new ArrayList<Object>();
        ClassInfo parentClassInfo = this.session.metaData().classInfo(parent);
        if (parentClassInfo != null) {
            for (FieldInfo reader : parentClassInfo.relationshipFields()) {
                Object reference = reader.read(parent);
                if (reference == null) continue;
                CollectionUtils.iterableOf((Object)reference).forEach(children::add);
            }
        }
        return children;
    }

    private Collection<FieldInfo> relationalReaders(Object object) {
        return this.session.metaData().classInfo(object).relationshipFields();
    }

    private Collection<MappedRelationship> map(ClassInfo parentInfo, long parentId, Object reference, FieldInfo fieldInfo) {
        if (reference == null) {
            return Collections.emptySet();
        }
        HashSet<MappedRelationship> mappedRelationships = new HashSet<MappedRelationship>();
        CollectionUtils.iterableOf((Object)reference).forEach(r -> this.mapInstance(mappedRelationships, parentInfo, parentId, fieldInfo, r));
        return mappedRelationships;
    }

    private void mapInstance(Set<MappedRelationship> mappedRelationships, ClassInfo parentInfo, long parentId, FieldInfo reader, Object reference) {
        String type = reader.relationshipType();
        String direction = reader.relationshipDirection();
        ClassInfo referenceInfo = this.session.metaData().classInfo(reference);
        if (referenceInfo == null) {
            return;
        }
        if (referenceInfo.isRelationshipEntity()) {
            Optional<Long> optionalReferenceId = this.session.context().optionalNativeId(reference);
            Object startNode = referenceInfo.getStartNodeReader().read(reference);
            ClassInfo startNodeInfo = this.session.metaData().classInfo(startNode);
            Long startNodeId = this.session.context().nativeId(startNode);
            Object endNode = referenceInfo.getEndNodeReader().read(reference);
            ClassInfo endNodeInfo = this.session.metaData().classInfo(endNode);
            Long endNodeId = this.session.context().nativeId(endNode);
            MappedRelationship edge = new MappedRelationship(startNodeId, type, endNodeId, optionalReferenceId.orElse(null), startNodeInfo.getUnderlyingClass(), endNodeInfo.getUnderlyingClass());
            mappedRelationships.add(edge);
        } else {
            Long referenceId = this.session.context().nativeId(reference);
            if (direction.equals("OUTGOING")) {
                MappedRelationship edge = new MappedRelationship(parentId, type, referenceId, null, parentInfo.getUnderlyingClass(), referenceInfo.getUnderlyingClass());
                mappedRelationships.add(edge);
            } else {
                MappedRelationship edge = new MappedRelationship(referenceId, type, parentId, null, referenceInfo.getUnderlyingClass(), parentInfo.getUnderlyingClass());
                mappedRelationships.add(edge);
            }
        }
    }
}

