/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.ogm.autoindex.AutoIndexManager;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.core.ConfigurationException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.LoadStrategy;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.event.EventListener;

public class SessionFactory {
    private final MetaData metaData;
    private final Driver driver;
    private final List<EventListener> eventListeners;
    private final boolean useStrictQuerying;
    private LoadStrategy loadStrategy = LoadStrategy.SCHEMA_LOAD_STRATEGY;
    private EntityInstantiator entityInstantiator;

    public SessionFactory(String ... packages) {
        this(new Configuration.Builder().build(), packages);
    }

    public SessionFactory(Configuration configuration, String ... packages) {
        this(SessionFactory.newConfiguredDriverInstance(configuration), configuration.mergeBasePackagesWith(packages));
        if (configuration.getAutoIndex() != AutoIndexMode.NONE) {
            this.runAutoIndexManager(configuration);
        }
    }

    public SessionFactory(Driver driver, String ... packages) {
        this(driver, Optional.ofNullable(driver.getConfiguration()).map(Configuration::getUseStrictQuerying).orElse(false), packages);
    }

    public SessionFactory(Driver driver, boolean useStrictQuerying, String ... packages) {
        this.metaData = new MetaData(driver.getTypeSystem(), packages);
        this.driver = driver;
        this.useStrictQuerying = useStrictQuerying;
        this.eventListeners = new CopyOnWriteArrayList<EventListener>();
        this.entityInstantiator = new ReflectionEntityInstantiator(this.metaData);
    }

    public final void runAutoIndexManager(Configuration configuration) {
        Neo4jSession neo4jSession = (Neo4jSession)this.openSession();
        AutoIndexManager autoIndexManager = new AutoIndexManager(this.metaData, configuration, neo4jSession);
        autoIndexManager.run();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public Session openSession() {
        return new Neo4jSession(this.metaData, this.useStrictQuerying, this.driver, this.eventListeners, this.loadStrategy, this.entityInstantiator);
    }

    public void register(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void deregister(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    public boolean isUseStrictQuerying() {
        return this.useStrictQuerying;
    }

    public void setEntityInstantiator(EntityInstantiator entityInstantiator) {
        this.entityInstantiator = entityInstantiator;
    }

    public void close() {
        this.driver.close();
    }

    public void register(IdStrategy strategy) {
        Objects.requireNonNull(strategy);
        for (ClassInfo classInfo : this.metaData.persistentEntities()) {
            if (!strategy.getClass().equals(classInfo.idStrategyClass())) continue;
            classInfo.registerIdGenerationStrategy(strategy);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrappedInstance = clazz.isInstance(this.driver) ? clazz.cast(this.driver) : this.driver.unwrap(clazz);
        return unwrappedInstance;
    }

    private static Driver newConfiguredDriverInstance(Configuration configuration) {
        String driverClassName = configuration.getDriverClassName();
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            Driver driver = (Driver)driverClass.newInstance();
            driver.configure(configuration);
            return driver;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Could not load driver class " + driverClassName, e);
        }
    }
}

