/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.exception.core.AmbiguousBaseClassException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.schema.DomainInfoSchemaBuilder;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaData.class);
    private final DomainInfo domainInfo;
    private final Schema schema;

    public MetaData(String ... packages) {
        this((TypeSystem)TypeSystem.NoNativeTypes.INSTANCE, packages);
    }

    public MetaData(TypeSystem typeSystem, String ... packages) {
        if (MetaData.containsRootPackage(packages)) {
            LOGGER.warn("You are trying to scan the root package. This will take a long time and probably end with an error or classes being mapped that are not part of your domain. Please have a look at the configuration of your SessionFactory.");
        }
        this.domainInfo = DomainInfo.create(typeSystem, packages);
        this.schema = new DomainInfoSchemaBuilder(this.domainInfo).build();
    }

    static boolean containsRootPackage(String ... packages) {
        return packages == null || packages.length == 0 || Arrays.stream(packages).anyMatch(String::isEmpty);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ClassInfo classInfo(String name) {
        ClassInfo classInfo = this._classInfo(name, NodeEntity.class);
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = this._classInfo(name, RelationshipEntity.class);
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = this.domainInfo.getClassSimpleName(name);
        if (classInfo != null) {
            return classInfo;
        }
        return null;
    }

    public ClassInfo classInfo(Class<?> clazz) {
        return this.classInfo(clazz.getName());
    }

    public ClassInfo classInfo(Object object) {
        return this.classInfo(object.getClass().getName());
    }

    private ClassInfo _classInfo(String name, Class<?> nodeEntityAnnotation) {
        Map<String, List<ClassInfo>> labelledClasses;
        if (nodeEntityAnnotation == NodeEntity.class) {
            labelledClasses = this.domainInfo.getNodeEntitiesByLabel();
        } else if (nodeEntityAnnotation == RelationshipEntity.class) {
            labelledClasses = this.domainInfo.getRelationshipEntitiesByType();
        } else {
            throw new IllegalArgumentException("Cannot retrieve class infos for annotation " + nodeEntityAnnotation.toString());
        }
        List classInfos = labelledClasses.getOrDefault(name, Collections.emptyList());
        return classInfos.isEmpty() ? null : (ClassInfo)classInfos.get(0);
    }

    public ClassInfo resolve(String ... taxa) {
        if (taxa.length > 0) {
            HashSet<ClassInfo> resolved = new HashSet<ClassInfo>();
            for (String taxon : taxa) {
                LOGGER.debug("looking for concrete class to resolve label: {}", (Object)taxon);
                ClassInfo taxonClassInfo = this.classInfo(taxon);
                if (taxonClassInfo == null) {
                    LOGGER.debug("This label is not known in the mapping context. Moving on...");
                    continue;
                }
                if (taxonClassInfo.isInterface()) {
                    LOGGER.debug("label is on an interface. Looking for a single implementing class...");
                    taxonClassInfo = this.findSingleImplementor(taxonClassInfo);
                } else if (taxonClassInfo.isAbstract()) {
                    LOGGER.debug("label is on an abstract class. Looking for a single concrete subclass...");
                    taxonClassInfo = this.findFirstSingleConcreteClass(taxonClassInfo, taxonClassInfo.directSubclasses());
                }
                if (taxonClassInfo != null) {
                    LOGGER.debug("concrete class found: {}. comparing with what's already been found previously...", (Object)taxonClassInfo);
                    for (ClassInfo found : resolved) {
                        if (taxonClassInfo.isSubclassOf(found)) {
                            LOGGER.debug("{} is a subclass of {} and will replace it.", (Object)taxonClassInfo, (Object)found);
                            resolved.remove(found);
                        } else {
                            if (!found.isSubclassOf(taxonClassInfo)) continue;
                            LOGGER.debug("{} is a superclass of {} and will be ignored", (Object)taxonClassInfo, (Object)found);
                            taxonClassInfo = null;
                        }
                        break;
                    }
                } else {
                    LOGGER.debug("no implementing class or concrete subclass found!");
                }
                if (taxonClassInfo == null) continue;
                LOGGER.debug("{} resolving class: {}", (Object)taxon, (Object)taxonClassInfo);
                resolved.add(taxonClassInfo);
            }
            if (resolved.size() > 1) {
                Object[] sorted = Arrays.copyOf(taxa, taxa.length);
                Arrays.sort(sorted);
                throw new AmbiguousBaseClassException(Arrays.toString(sorted));
            }
            if (resolved.iterator().hasNext()) {
                return (ClassInfo)resolved.iterator().next();
            }
        }
        LOGGER.debug("No resolving class found!!");
        return null;
    }

    public Set<ClassInfo> classInfoByLabelOrType(String name) {
        HashSet<ClassInfo> matchingClassInfos = new HashSet<ClassInfo>();
        ClassInfo classInfo = this._classInfo(name, NodeEntity.class);
        if (classInfo != null) {
            matchingClassInfos.add(classInfo);
        }
        matchingClassInfos.addAll(this.domainInfo.getRelationshipEntitiesByType().getOrDefault(name, Collections.emptyList()));
        classInfo = this.domainInfo.getClassSimpleName(name);
        if (classInfo != null) {
            matchingClassInfos.add(classInfo);
        }
        return matchingClassInfos;
    }

    private ClassInfo findFirstSingleConcreteClass(ClassInfo root, List<ClassInfo> classInfoList) {
        if (!root.isInterface() && !root.isAbstract()) {
            return root;
        }
        if (classInfoList.isEmpty()) {
            return null;
        }
        if (classInfoList.size() > 1) {
            LOGGER.debug("More than one class subclasses {}", (Object)root);
            return null;
        }
        ClassInfo classInfo = classInfoList.iterator().next();
        if (classInfo.isInterface()) {
            classInfo = this.findSingleImplementor(classInfo);
        }
        return classInfo == null ? null : this.findFirstSingleConcreteClass(classInfo, classInfo.directSubclasses());
    }

    public boolean isRelationshipEntity(String className) {
        ClassInfo classInfo = this.classInfo(className);
        return classInfo != null && null != classInfo.annotationsInfo().get(RelationshipEntity.class);
    }

    private ClassInfo findSingleImplementor(ClassInfo interfaceInfo) {
        if (interfaceInfo != null && interfaceInfo.directImplementingClasses() != null && interfaceInfo.directImplementingClasses().size() == 1) {
            return interfaceInfo.directImplementingClasses().get(0);
        }
        return null;
    }

    public Collection<ClassInfo> persistentEntities() {
        return this.domainInfo.getClassInfoMap().values();
    }

    public String entityType(String name) {
        ClassInfo classInfo = this.classInfo(name);
        if (classInfo == null) {
            return null;
        }
        if (classInfo.isRelationshipEntity()) {
            AnnotationInfo annotation = classInfo.annotationsInfo().get(RelationshipEntity.class);
            return annotation.get("type", classInfo.name());
        }
        return classInfo.neo4jName();
    }

    public List<ClassInfo> getImplementingClassInfos(String interfaceName) {
        return this.domainInfo.getClassInfos(interfaceName);
    }

    public void registerConversionCallback(ConversionCallback conversionCallback) {
        this.domainInfo.registerConversionCallback(conversionCallback);
    }

    public <T> ClassInfo register(Class<T> clazz) {
        return this.domainInfo.addClass(clazz);
    }
}

