/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.DefaultRequest;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.utils.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    private Neo4jSession session;

    public RequestExecutor(Neo4jSession session) {
        this.session = session;
    }

    public void executeSave(CompileContext context) {
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory(new RowStatementFactory());
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        boolean forceTx = compiler.updateNodesStatements().stream().anyMatch(st -> st.optimisticLockingConfig().isPresent()) || compiler.updateRelationshipStatements().stream().anyMatch(st -> st.optimisticLockingConfig().isPresent());
        this.session.doInTransaction(() -> {
            if (compiler.hasStatementsDependentOnNewNodes()) {
                this.executeStatements(context, entityReferenceMappings, relReferenceMappings, compiler.createNodesStatements());
                ArrayList<Statement> statements = new ArrayList<Statement>();
                statements.addAll(compiler.createRelationshipsStatements());
                statements.addAll(compiler.updateNodesStatements());
                statements.addAll(compiler.updateRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipEntityStatements());
                this.executeStatements(context, entityReferenceMappings, relReferenceMappings, statements);
            } else {
                List<Statement> statements = compiler.getAllStatements();
                this.executeStatements(context, entityReferenceMappings, relReferenceMappings, statements);
            }
        }, forceTx, Transaction.Type.READ_WRITE);
        this.updateNodeEntities(context, entityReferenceMappings);
        this.updateRelationshipEntities(context, relReferenceMappings);
        this.updateRelationships(context, relReferenceMappings);
    }

    private void executeStatements(CompileContext context, List<ReferenceMapping> entityReferenceMappings, List<ReferenceMapping> relReferenceMappings, List<Statement> statements) {
        if (statements.size() > 0) {
            ArrayList<Statement> noCheckStatements = new ArrayList<Statement>();
            for (Statement statement : statements) {
                if (statement.optimisticLockingConfig().isPresent()) {
                    DefaultRequest request = new DefaultRequest(statement);
                    Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)request);
                    Throwable throwable = null;
                    try {
                        List rowModels = response.toList();
                        this.session.optimisticLockingChecker().checkResultsCount(rowModels, statement);
                        this.registerEntityIds(context, rowModels, entityReferenceMappings, relReferenceMappings);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        response.close();
                        continue;
                    }
                }
                noCheckStatements.add(statement);
            }
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(noCheckStatements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerEntityIds(context, response.toList(), entityReferenceMappings, relReferenceMappings);
            }
        }
    }

    private void registerEntityIds(CompileContext context, List<RowModel> response, List<ReferenceMapping> entityRefMappings, List<ReferenceMapping> relEntityRefMappings) {
        for (RowModel rowModel : response) {
            Object[] results = rowModel.getValues();
            String[] variables = rowModel.variables();
            Long entityRef = null;
            Long entityId = null;
            String type = null;
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].equals("id")) {
                    entityId = ((Number)results[i]).longValue();
                }
                if (variables[i].equals("ref")) {
                    entityRef = ((Number)results[i]).longValue();
                }
                if (!variables[i].equals("type")) continue;
                type = (String)results[i];
            }
            if (type != null && type.equals("node")) {
                entityRefMappings.add(new ReferenceMapping(entityRef, entityId));
                if (entityRef != null && entityRef.equals(entityId)) {
                    LOGGER.debug("to update: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                    continue;
                }
                LOGGER.debug("to create: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                context.registerNewId(entityRef, entityId);
                continue;
            }
            if (type == null || !type.equals("rel")) continue;
            relEntityRefMappings.add(new ReferenceMapping(entityRef, entityId));
            if (entityRef != null && entityRef.equals(entityId)) {
                LOGGER.debug("to (maybe) update: relEntity {}:{}", (Object)entityRef, (Object)entityId);
                continue;
            }
            LOGGER.debug("to (maybe) create: relEntity {}:{}", (Object)entityRef, (Object)entityId);
            context.registerNewId(entityRef, entityId);
        }
    }

    private void updateNodeEntities(CompileContext context, List<ReferenceMapping> entityRefMappings) {
        for (Object obj : context.registry()) {
            ClassInfo classInfo;
            if (obj instanceof TransientRelationship || (classInfo = this.session.metaData().classInfo(obj)).isRelationshipEntity()) continue;
            this.session.context().optionalNativeId(obj).filter(id -> id >= 0L).ifPresent(id -> {
                LOGGER.debug("updating existing node id: {}, {}", id, obj);
                this.registerEntity(this.session.context(), classInfo, (Long)id, obj);
            });
        }
        for (ReferenceMapping referenceMapping : entityRefMappings) {
            if (referenceMapping.ref.equals(referenceMapping.id)) continue;
            Object newEntity = context.getNewObject(referenceMapping.ref);
            LOGGER.debug("creating new node id: {}, {}, {}", new Object[]{referenceMapping.ref, referenceMapping.id, newEntity});
            this.initialiseNewEntity(referenceMapping.id, newEntity);
        }
    }

    private void updateRelationshipEntities(CompileContext context, List<ReferenceMapping> relationshipEntityRefMappings) {
        for (ReferenceMapping referenceMapping : relationshipEntityRefMappings) {
            if (referenceMapping.ref.equals(referenceMapping.id)) {
                Object existingRelationshipEntity = this.session.context().getRelationshipEntity(referenceMapping.id);
                if (existingRelationshipEntity == null) continue;
                LOGGER.debug("updating existing relationship entity id: {}", (Object)referenceMapping.id);
                ClassInfo classInfo = this.session.metaData().classInfo(existingRelationshipEntity);
                this.registerEntity(this.session.context(), classInfo, referenceMapping.id, existingRelationshipEntity);
                continue;
            }
            Object newRelationshipEntity = context.getNewObject(referenceMapping.ref);
            if (newRelationshipEntity == null) continue;
            LOGGER.debug("creating new relationship entity id: {}", (Object)referenceMapping.id);
            this.initialiseNewEntity(referenceMapping.id, newRelationshipEntity);
        }
    }

    private void updateRelationships(CompileContext context, List<ReferenceMapping> relRefMappings) {
        Map<Long, TransientRelationship> registeredTransientRelationshipIndex = this.buildRegisteredTransientRelationshipIndex(context);
        for (ReferenceMapping referenceMapping : relRefMappings) {
            if (!registeredTransientRelationshipIndex.containsKey(referenceMapping.ref)) continue;
            TransientRelationship transientRelationship = registeredTransientRelationshipIndex.get(referenceMapping.ref);
            boolean isRelationshipEntity = this.session.context().getRelationshipEntity(referenceMapping.id) != null;
            MappedRelationship mappedRelationship = new MappedRelationship(context.getId(transientRelationship.getSrc()), transientRelationship.getRel(), context.getId(transientRelationship.getTgt()), isRelationshipEntity ? referenceMapping.id : null, transientRelationship.getSrcClass(), transientRelationship.getTgtClass());
            this.session.context().addRelationship(mappedRelationship);
        }
    }

    private Map<Long, TransientRelationship> buildRegisteredTransientRelationshipIndex(CompileContext context) {
        HashMap<Long, TransientRelationship> transientRelationshipIndex = new HashMap<Long, TransientRelationship>();
        for (Object obj : context.registry()) {
            if (!TransientRelationship.class.isAssignableFrom(obj.getClass())) continue;
            TransientRelationship transientRelationship = (TransientRelationship)obj;
            transientRelationshipIndex.put(transientRelationship.getRef(), transientRelationship);
        }
        return transientRelationshipIndex;
    }

    private void initialiseNewEntity(Long identity, Object persisted) {
        MappingContext mappingContext = this.session.context();
        Transaction tx = this.session.getTransaction();
        if (persisted != null) {
            EntityUtils.setIdentity(persisted, identity, this.session.metaData());
            ClassInfo classInfo = this.session.metaData().classInfo(persisted);
            if (tx != null) {
                ((AbstractTransaction)tx).registerNew(persisted);
            }
            this.registerEntity(mappingContext, classInfo, identity, persisted);
        }
    }

    private void registerEntity(MappingContext mappingContext, ClassInfo classInfo, Long identity, Object entity) {
        if (classInfo.annotationsInfo().get(RelationshipEntity.class) == null) {
            mappingContext.replaceNodeEntity(entity, identity);
        } else {
            mappingContext.replaceRelationshipEntity(entity, identity);
        }
    }

    static class ReferenceMapping {
        private Long ref;
        private Long id;

        ReferenceMapping(Long ref, Long id) {
            this.ref = ref;
            this.id = id;
        }
    }
}

