/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.ogm.compiler.SrcTargetKey;
import org.neo4j.ogm.context.Mappable;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;

public class CypherContext
implements CompileContext {
    private final Map<Object, NodeBuilderHorizonPair> visitedObjects = new IdentityHashMap<Object, NodeBuilderHorizonPair>();
    private final Set<Long> visitedRelationshipEntities = new HashSet<Long>();
    private final Map<Long, Object> createdObjectsWithId = new HashMap<Long, Object>();
    private final Map<Long, Long> newNodeIds = new HashMap<Long, Long>();
    private final Set<Mappable> registeredRelationships = new HashSet<Mappable>();
    private final Set<Mappable> deletedRelationships = new HashSet<Mappable>();
    private final Set<Object> registry = new HashSet<Object>();
    private final Map<SrcTargetKey, Set<Object>> transientRelsIndex = new HashMap<SrcTargetKey, Set<Object>>();
    private final Compiler compiler;
    private final Function<Object, Long> nativeIdProvider;

    public CypherContext(Compiler compiler, Function<Object, Long> nativeIdProvider) {
        this.compiler = compiler;
        this.nativeIdProvider = nativeIdProvider;
    }

    private Object getIdentity(Object entity) {
        Long nativeId = this.nativeIdProvider.apply(entity);
        return nativeId == null || nativeId < 0L ? entity : nativeId;
    }

    @Override
    public boolean visited(Object entity, int horizon) {
        NodeBuilderHorizonPair pair = this.visitedObjects.get(this.getIdentity(entity));
        return pair != null && (horizon < 0 || pair.getHorizon() > horizon);
    }

    @Override
    public void visit(Object entity, NodeBuilder nodeBuilder, int horizon) {
        this.visitedObjects.put(this.getIdentity(entity), new NodeBuilderHorizonPair(nodeBuilder, horizon));
    }

    @Override
    public void registerRelationship(Mappable mappedRelationship) {
        this.registeredRelationships.add(mappedRelationship);
    }

    @Override
    public boolean removeRegisteredRelationship(Mappable mappedRelationship) {
        return this.registeredRelationships.remove(mappedRelationship);
    }

    @Override
    public NodeBuilder visitedNode(Object entity) {
        NodeBuilderHorizonPair pair = this.visitedObjects.get(this.getIdentity(entity));
        return pair != null ? pair.getNodeBuilder() : null;
    }

    @Override
    public void registerNewObject(Long reference, Object entity) {
        this.createdObjectsWithId.put(reference, entity);
        this.register(entity);
    }

    @Override
    public Object getNewObject(Long id) {
        return this.createdObjectsWithId.get(id);
    }

    @Override
    public void register(Object object) {
        if (!this.registry.contains(object)) {
            this.registry.add(object);
        }
    }

    @Override
    public void registerTransientRelationship(SrcTargetKey key, Object object) {
        if (!this.registry.contains(object)) {
            this.registry.add(object);
            Set collection = this.transientRelsIndex.computeIfAbsent(key, k -> new HashSet());
            collection.add(object);
        }
    }

    @Override
    public Collection<Object> registry() {
        return Collections.unmodifiableSet(this.registry);
    }

    @Override
    public boolean deregisterOutgoingRelationships(Long src, String relationshipType, Class endNodeType) {
        return this.deregisterRelationshipsImpl(src, relationshipType, endNodeType, Mappable::getStartNodeId, Mappable::getEndNodeType);
    }

    @Override
    public boolean deregisterIncomingRelationships(Long tgt, String relationshipType, Class endNodeType, boolean relationshipEntity) {
        Function<Mappable, Class> endNodeTypeExtractor = relationshipEntity ? Mappable::getEndNodeType : Mappable::getStartNodeType;
        return this.deregisterRelationshipsImpl(tgt, relationshipType, endNodeType, Mappable::getEndNodeId, endNodeTypeExtractor);
    }

    private boolean deregisterRelationshipsImpl(Long nodeId, String relationshipType, Class endNodeType, Function<Mappable, Long> candidateNodeIdExtractor, Function<Mappable, Class> candidateNodeTypeExtractor) {
        ArrayList<Mappable> boundForDeletion = new ArrayList<Mappable>();
        Iterator<Mappable> candidatesForDeletion = this.registeredRelationships.iterator();
        boolean existsInGraph = false;
        while (candidatesForDeletion.hasNext()) {
            Mappable candidate = candidatesForDeletion.next();
            long candidateNodeId = candidateNodeIdExtractor.apply(candidate);
            String candidateRelationshipType = candidate.getRelationshipType();
            Class candidateNodeType = candidateNodeTypeExtractor.apply(candidate);
            if (candidateNodeId != nodeId || !candidateRelationshipType.equals(relationshipType) || !candidateNodeType.equals(endNodeType)) continue;
            existsInGraph = true;
            if (this.isAlreadyDeleted(candidate)) continue;
            boundForDeletion.add(candidate);
            candidatesForDeletion.remove();
        }
        this.deletedRelationships.addAll(boundForDeletion);
        boolean aCandidateMarkedForDeletion = !boundForDeletion.isEmpty();
        return !existsInGraph || aCandidateMarkedForDeletion;
    }

    @Override
    public void visitRelationshipEntity(Long relationshipEntity) {
        this.visitedRelationshipEntities.add(relationshipEntity);
    }

    @Override
    public boolean visitedRelationshipEntity(Long relationshipEntity) {
        return this.visitedRelationshipEntities.contains(relationshipEntity);
    }

    @Override
    public Compiler getCompiler() {
        return this.compiler;
    }

    @Override
    public Long getId(Long reference) {
        if (this.newNodeIds.containsKey(reference)) {
            return this.newNodeIds.get(reference);
        }
        return reference;
    }

    @Override
    public void registerNewId(Long reference, Long id) {
        this.newNodeIds.put(reference, id);
    }

    @Override
    public void deregister(NodeBuilder nodeBuilder) {
        this.compiler.unmap(nodeBuilder);
    }

    @Override
    public Collection<Object> getTransientRelationships(SrcTargetKey srcTargetKey) {
        Collection objects = this.transientRelsIndex.get(srcTargetKey);
        if (objects != null) {
            return objects;
        }
        return Collections.emptySet();
    }

    private boolean isAlreadyDeleted(Mappable mappedRelationship) {
        return this.deletedRelationships.contains(mappedRelationship);
    }

    private static class NodeBuilderHorizonPair {
        private final NodeBuilder nodeBuilder;
        private final int horizon;

        private NodeBuilderHorizonPair(NodeBuilder nodeBuilder, int horizon) {
            this.nodeBuilder = nodeBuilder;
            this.horizon = horizon;
        }

        public NodeBuilder getNodeBuilder() {
            return this.nodeBuilder;
        }

        public int getHorizon() {
            return this.horizon;
        }
    }
}

