/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.CypherContext;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.builders.node.DefaultNodeBuilder;
import org.neo4j.ogm.cypher.compiler.builders.node.DefaultRelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.DeletedRelationshipEntityStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.DeletedRelationshipStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.ExistingNodeStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.ExistingRelationshipStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.NewNodeStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.NewRelationshipStatementBuilder;
import org.neo4j.ogm.exception.core.UnknownStatementTypeException;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.response.model.RelationshipModel;

public class MultiStatementCypherCompiler
implements Compiler {
    private final CompileContext context;
    private final List<NodeBuilder> newNodeBuilders;
    private final List<RelationshipBuilder> newRelationshipBuilders;
    private final Map<Long, NodeBuilder> existingNodeBuilders;
    private final Map<String, RelationshipBuilder> existingRelationshipBuilders;
    private final List<RelationshipBuilder> deletedRelationshipBuilders;
    private final List<RelationshipBuilder> deletedRelationshipEntityBuilders;
    private StatementFactory statementFactory;

    public MultiStatementCypherCompiler(Function<Object, Long> nativeIdProvider) {
        this.context = new CypherContext(this, nativeIdProvider);
        this.newNodeBuilders = new ArrayList<NodeBuilder>();
        this.newRelationshipBuilders = new ArrayList<RelationshipBuilder>();
        this.existingNodeBuilders = new HashMap<Long, NodeBuilder>();
        this.existingRelationshipBuilders = new LinkedHashMap<String, RelationshipBuilder>();
        this.deletedRelationshipBuilders = new ArrayList<RelationshipBuilder>();
        this.deletedRelationshipEntityBuilders = new ArrayList<RelationshipBuilder>();
    }

    @Override
    public NodeBuilder newNode(Long id) {
        DefaultNodeBuilder nodeBuilder = new DefaultNodeBuilder(id);
        this.newNodeBuilders.add(nodeBuilder);
        return nodeBuilder;
    }

    @Override
    public RelationshipBuilder newRelationship(String type, boolean bidirectional) {
        DefaultRelationshipBuilder relationshipBuilder = new DefaultRelationshipBuilder(type, bidirectional);
        this.newRelationshipBuilders.add(relationshipBuilder);
        return relationshipBuilder;
    }

    @Override
    public RelationshipBuilder newRelationship(String type) {
        return this.newRelationship(type, false);
    }

    @Override
    public NodeBuilder existingNode(Long existingNodeId) {
        return this.existingNodeBuilders.computeIfAbsent(existingNodeId, DefaultNodeBuilder::new);
    }

    @Override
    public RelationshipBuilder existingRelationship(Long existingRelationshipId, String direction, String type, boolean wasDirty) {
        String key = existingRelationshipId + ";" + direction;
        RelationshipBuilder relationshipBuilder = this.existingRelationshipBuilders.computeIfAbsent(key, k -> new DefaultRelationshipBuilder(type, existingRelationshipId));
        relationshipBuilder.setDirty(wasDirty);
        return relationshipBuilder;
    }

    @Override
    public RelationshipBuilder unrelate(Long startNode, String relationshipType, Long endNode, Long relId) {
        DefaultRelationshipBuilder relationshipBuilder = new DefaultRelationshipBuilder(relationshipType, relId);
        relationshipBuilder.relate(startNode, endNode);
        if (!this.unmap(relationshipBuilder)) {
            if (relId != null) {
                this.deletedRelationshipEntityBuilders.add(relationshipBuilder);
            } else {
                this.deletedRelationshipBuilders.add(relationshipBuilder);
            }
        }
        return relationshipBuilder;
    }

    @Override
    public void unmap(NodeBuilder nodeBuilder) {
        if (nodeBuilder.reference() != null) {
            this.existingNodeBuilders.remove(nodeBuilder.reference());
        } else {
            Iterator<Map.Entry<Long, NodeBuilder>> it = this.existingNodeBuilders.entrySet().iterator();
            while (it.hasNext()) {
                NodeBuilder builder = it.next().getValue();
                if (builder != nodeBuilder) continue;
                it.remove();
            }
        }
    }

    @Override
    public List<Statement> createNodesStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Node>> newNodesByLabels = this.groupNodesByLabel(this.newNodeBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>(newNodesByLabels.size());
        for (Set<Node> nodeModels : newNodesByLabels.values()) {
            NewNodeStatementBuilder newNodeBuilder = new NewNodeStatementBuilder(nodeModels, this.statementFactory);
            statements.add(newNodeBuilder.build());
        }
        return statements;
    }

    @Override
    public List<Statement> createRelationshipsStatements() {
        this.assertStatementFactoryExists();
        HashMap<String, Map> relsByTypeAndProps = new HashMap<String, Map>();
        for (RelationshipBuilder relationshipBuilder : this.newRelationshipBuilders) {
            if (relationshipBuilder.edge().getStartNode() == null || relationshipBuilder.edge().getEndNode() == null) continue;
            Map relsByProps = relsByTypeAndProps.computeIfAbsent(relationshipBuilder.type(), key -> new HashMap());
            RelationshipModel edge = (RelationshipModel)relationshipBuilder.edge();
            String primaryId = edge.getPrimaryIdName();
            Set rels = relsByProps.computeIfAbsent(primaryId, s -> new HashSet());
            edge.setStartNode(this.context.getId(edge.getStartNode()));
            edge.setEndNode(this.context.getId(edge.getEndNode()));
            rels.add(edge);
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Map edgesByProperties : relsByTypeAndProps.values()) {
            for (Set edges : edgesByProperties.values()) {
                NewRelationshipStatementBuilder newRelationshipBuilder = new NewRelationshipStatementBuilder(edges, this.statementFactory);
                statements.add(newRelationshipBuilder.build());
            }
        }
        return statements;
    }

    @Override
    public List<Statement> updateNodesStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Node>> existingNodesByLabels = this.groupNodesByLabel(this.existingNodeBuilders.values());
        ArrayList<Statement> statements = new ArrayList<Statement>(existingNodesByLabels.size());
        for (Set<Node> nodeModels : existingNodesByLabels.values()) {
            ExistingNodeStatementBuilder existingNodeBuilder = new ExistingNodeStatementBuilder(nodeModels, this.statementFactory);
            statements.add(existingNodeBuilder.build());
        }
        return statements;
    }

    @Override
    public List<Statement> updateRelationshipStatements() {
        ExistingRelationshipStatementBuilder builder;
        this.assertStatementFactoryExists();
        if (this.existingRelationshipBuilders.isEmpty()) {
            return Collections.emptyList();
        }
        Map collect = this.existingRelationshipBuilders.values().stream().collect(Collectors.partitioningBy(RelationshipBuilder::isDirty, Collectors.mapping(RelationshipBuilder::edge, Collectors.toSet())));
        ArrayList<Statement> result = new ArrayList<Statement>();
        if (!collect.get(true).isEmpty()) {
            builder = new ExistingRelationshipStatementBuilder(collect.get(true), this.statementFactory, true);
            result.add(builder.build());
        }
        if (!collect.get(false).isEmpty()) {
            builder = new ExistingRelationshipStatementBuilder(collect.get(false), this.statementFactory, false);
            result.add(builder.build());
        }
        return result;
    }

    @Override
    public List<Statement> deleteRelationshipStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Edge>> deletedRelsByType = this.groupRelationshipsByType(this.deletedRelationshipBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Set<Edge> edges : deletedRelsByType.values()) {
            DeletedRelationshipStatementBuilder deletedRelationshipBuilder = new DeletedRelationshipStatementBuilder(edges, this.statementFactory);
            statements.add(deletedRelationshipBuilder.build());
        }
        return statements;
    }

    @Override
    public List<Statement> deleteRelationshipEntityStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Edge>> deletedRelsByType = this.groupRelationshipsByType(this.deletedRelationshipEntityBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Set<Edge> edges : deletedRelsByType.values()) {
            DeletedRelationshipEntityStatementBuilder deletedRelationshipBuilder = new DeletedRelationshipEntityStatementBuilder(edges, this.statementFactory);
            statements.add(deletedRelationshipBuilder.build());
        }
        return statements;
    }

    @Override
    public List<Statement> getAllStatements() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.addAll(this.createNodesStatements());
        statements.addAll(this.createRelationshipsStatements());
        statements.addAll(this.updateNodesStatements());
        statements.addAll(this.updateRelationshipStatements());
        statements.addAll(this.deleteRelationshipStatements());
        statements.addAll(this.deleteRelationshipEntityStatements());
        return statements;
    }

    @Override
    public CompileContext context() {
        return this.context;
    }

    @Override
    public boolean hasStatementsDependentOnNewNodes() {
        for (RelationshipBuilder builder : this.newRelationshipBuilders) {
            Edge edge = builder.edge();
            if ((edge.getStartNode() == null || edge.getStartNode() >= 0L) && (edge.getEndNode() == null || edge.getEndNode() >= 0L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void useStatementFactory(StatementFactory newStatementFactory) {
        this.statementFactory = newStatementFactory;
    }

    private boolean unmap(RelationshipBuilder relationshipBuilder) {
        boolean unmapped = false;
        Iterator<RelationshipBuilder> relIterator = this.newRelationshipBuilders.iterator();
        while (relIterator.hasNext()) {
            RelationshipBuilder newRelBuilder = relIterator.next();
            if (relationshipBuilder.reference() >= 0L) {
                if (!relationshipBuilder.reference().equals(newRelBuilder.reference())) continue;
                relIterator.remove();
                unmapped = true;
                break;
            }
            if (!relationshipBuilder.type().equals(newRelBuilder.type()) || !relationshipBuilder.edge().getStartNode().equals(newRelBuilder.edge().getStartNode()) || !relationshipBuilder.edge().getEndNode().equals(newRelBuilder.edge().getEndNode())) continue;
            relIterator.remove();
            unmapped = true;
            break;
        }
        return unmapped;
    }

    private void assertStatementFactoryExists() {
        if (this.statementFactory == null) {
            throw new UnknownStatementTypeException("Unknown statement type- statementFactory must be specified!");
        }
    }

    private Map<String, Set<Node>> groupNodesByLabel(Collection<NodeBuilder> nodeBuilders) {
        return nodeBuilders.stream().map(NodeBuilder::node).collect(Collectors.groupingBy(Node::labelSignature, Collectors.mapping(Function.identity(), Collectors.toSet())));
    }

    private Map<String, Set<Edge>> groupRelationshipsByType(List<RelationshipBuilder> relationshipBuilders) {
        HashMap<String, Set<Edge>> relsByType = new HashMap<String, Set<Edge>>();
        for (RelationshipBuilder relationshipBuilder : relationshipBuilders) {
            if (!relsByType.containsKey(relationshipBuilder.type())) {
                relsByType.put(relationshipBuilder.type(), new HashSet());
            }
            RelationshipModel edge = (RelationshipModel)relationshipBuilder.edge();
            edge.setStartNode(this.context.getId(edge.getStartNode()));
            edge.setEndNode(this.context.getId(edge.getEndNode()));
            ((Set)relsByType.get(relationshipBuilder.type())).add(edge);
            ((Set)relsByType.get(relationshipBuilder.type())).add(edge);
        }
        return relsByType;
    }
}

