/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DescriptorMappings {
    private static final Map<String, Class<?>> DESCRIPTORS_OF_PRIMITIVES = Arrays.asList(Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE).stream().collect(Collectors.collectingAndThen(Collectors.toMap(Class::getName, Function.identity()), Collections::unmodifiableMap));
    private static final Map<String, Class<?>> DESCRIPTORS_OF_WRAPPERS = Arrays.asList(Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Object.class, String.class).stream().collect(Collectors.collectingAndThen(Collectors.toMap(Class::getName, Function.identity()), Collections::unmodifiableMap));
    private static Map<String, Class<?>> descriptorsToTypeMappingCache = new ConcurrentHashMap();

    static boolean describesPrimitve(String descriptor) {
        return DESCRIPTORS_OF_PRIMITIVES.containsKey(DescriptorMappings.stripArraySuffix(descriptor));
    }

    static boolean describesWrapper(String descriptor) {
        return DESCRIPTORS_OF_WRAPPERS.containsKey(DescriptorMappings.stripArraySuffix(descriptor));
    }

    public static Class<?> getType(String descriptor) {
        Class<?> type = descriptorsToTypeMappingCache.get(descriptor);
        if (type == null || type.getClassLoader() != Thread.currentThread().getContextClassLoader()) {
            try {
                type = DescriptorMappings.computeType(descriptor);
                descriptorsToTypeMappingCache.put(descriptor, type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type;
    }

    private static Class<?> computeType(String descriptor) throws ClassNotFoundException {
        if (descriptor == null) {
            return null;
        }
        String rawDescriptor = DescriptorMappings.stripArraySuffix(descriptor);
        if (DESCRIPTORS_OF_WRAPPERS.containsKey(rawDescriptor)) {
            return DESCRIPTORS_OF_WRAPPERS.get(rawDescriptor);
        }
        if (DESCRIPTORS_OF_PRIMITIVES.containsKey(rawDescriptor)) {
            return DESCRIPTORS_OF_PRIMITIVES.get(rawDescriptor);
        }
        if (!rawDescriptor.contains(".") && !rawDescriptor.contains("$")) {
            return Object.class;
        }
        return Class.forName(rawDescriptor, false, Thread.currentThread().getContextClassLoader());
    }

    private static String stripArraySuffix(String descriptor) {
        return descriptor.replaceAll("\\[\\]$", "");
    }

    private DescriptorMappings() {
    }
}

