/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.OptimisticLockingUtils;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.PropertyContainer;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class ExistingNodeStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Node> existingNodes;

    public ExistingNodeStatementBuilder(Set<Node> existingNodes, StatementFactory statementFactory) {
        this.existingNodes = existingNodes;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.existingNodes != null && this.existingNodes.size() > 0) {
            Node firstNode = this.existingNodes.iterator().next();
            queryBuilder.append("UNWIND {rows} as row MATCH (n) WHERE ID(n)=row.nodeId ");
            if (firstNode.hasVersionProperty()) {
                queryBuilder.append(OptimisticLockingUtils.getFragmentForExistingNodesAndRelationships((PropertyContainer)firstNode, "n"));
            }
            Set previousDynamicLabels = firstNode.getPreviousDynamicLabels();
            for (String label : previousDynamicLabels) {
                queryBuilder.append(String.format(" REMOVE n:`%s` ", label));
            }
            queryBuilder.append(firstNode.createPropertyRemovalFragment("n"));
            queryBuilder.append("SET n");
            for (String label : firstNode.getLabels()) {
                queryBuilder.append(":`").append(label).append("`");
            }
            queryBuilder.append(" SET n += row.props RETURN row.nodeId as ref, ID(n) as id, {type} as type");
            List rows = this.existingNodes.stream().map(node -> node.toRow("nodeId")).collect(Collectors.toList());
            parameters.put("type", "node");
            parameters.put("rows", rows);
            if (firstNode.hasVersionProperty()) {
                OptimisticLockingConfig olConfig = new OptimisticLockingConfig(rows.size(), firstNode.getLabels(), (String)firstNode.getVersion().getKey());
                return this.statementFactory.statement(queryBuilder.toString(), parameters, olConfig);
            }
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

