/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.EntityInstantiator;

public class GraphRowModelMapper
implements ResponseMapper<GraphModel> {
    private final GraphEntityMapper delegate;

    public GraphRowModelMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.delegate = new GraphEntityMapper(metaData, mappingContext, entityInstantiator);
    }

    @Override
    public <T> Iterable<T> map(Class<T> type, Response<GraphModel> model) {
        List listOfGraphModels = model.toList();
        model.close();
        BiFunction<GraphModel, Long, Boolean> isNotGeneratedNode = (graphModel, nativeId) -> {
            Optional node = ((DefaultGraphModel)graphModel).findNode(nativeId);
            if (!node.isPresent()) {
                return true;
            }
            return node.map(n -> !((NodeModel)n).isGeneratedNode()).get();
        };
        return this.delegate.map(type, listOfGraphModels, isNotGeneratedNode, Collections.emptyMap());
    }
}

