/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.EntityInstantiator;

public class GraphRowListModelMapper
implements ResponseMapper<GraphRowListModel> {
    private final GraphEntityMapper delegate;

    public GraphRowListModelMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.delegate = new GraphEntityMapper(metaData, mappingContext, entityInstantiator);
    }

    @Override
    public <T> Iterable<T> map(Class<T> type, Response<GraphRowListModel> response) {
        List<GraphRowModel> listOfRowModels = response.toList().stream().flatMap(rowsModel -> rowsModel.model().stream()).collect(Collectors.toList());
        response.close();
        ArrayList<GraphModel> listOfGraphModels = new ArrayList<GraphModel>();
        LinkedHashSet idsOfResultEntities = new LinkedHashSet();
        listOfRowModels.forEach(graphRowModel -> {
            Set idsInCurrentRow = Arrays.stream(graphRowModel.getRow()).filter(Number.class::isInstance).map(Number.class::cast).map(Number::longValue).collect(Collectors.toSet());
            listOfGraphModels.add(graphRowModel.getGraph());
            idsOfResultEntities.addAll(idsInCurrentRow);
        });
        HashMap order = new HashMap();
        AtomicLong index = new AtomicLong(0L);
        idsOfResultEntities.forEach(id -> order.put(id, index.getAndIncrement()));
        BiFunction<GraphModel, Long, Boolean> includeModelObject = (graphModel, nativeId) -> idsOfResultEntities.contains(nativeId);
        return this.delegate.map(type, listOfGraphModels, includeModelObject, Collections.unmodifiableMap(order));
    }
}

