/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.node;

import java.util.Optional;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.builders.node.AbstractPropertyContainerBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.PropertyModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.utils.EntityUtils;

public class DefaultRelationshipBuilder
extends AbstractPropertyContainerBuilder<RelationshipBuilder, RelationshipModel>
implements RelationshipBuilder {
    private String direction;
    private boolean singleton = true;
    private boolean bidirectional = false;
    private boolean relationshipEntity = false;

    public DefaultRelationshipBuilder(String type, boolean bidirectional) {
        this(type, null);
        this.bidirectional = bidirectional;
    }

    public DefaultRelationshipBuilder(String type, Long relationshipId) {
        super(new RelationshipModel());
        ((RelationshipModel)this.targetContainer).setId(Optional.ofNullable(relationshipId).orElseGet(EntityUtils::nextRef));
        ((RelationshipModel)this.targetContainer).setType(type);
    }

    @Override
    public Long reference() {
        return ((RelationshipModel)this.targetContainer).getId();
    }

    @Override
    public void setType(String type) {
        ((RelationshipModel)this.targetContainer).setType(type);
    }

    @Override
    public RelationshipBuilder addProperty(String key, Object value) {
        ((RelationshipModel)this.targetContainer).getPropertyList().add(new PropertyModel((Object)key, value));
        return this;
    }

    @Override
    public void relate(Long startNodeId, Long endNodeId) {
        ((RelationshipModel)this.targetContainer).setStartNode(startNodeId);
        ((RelationshipModel)this.targetContainer).setEndNode(endNodeId);
    }

    @Override
    public String type() {
        return ((RelationshipModel)this.targetContainer).getType();
    }

    @Override
    public boolean hasDirection(String possibleDirection) {
        return this.direction != null && this.direction.equals(possibleDirection);
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public void setSingleton(boolean b) {
        this.singleton = b;
    }

    @Override
    public boolean isRelationshipEntity() {
        return this.relationshipEntity;
    }

    @Override
    public void setRelationshipEntity(boolean relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
    }

    @Override
    public RelationshipBuilder direction(String newDirection) {
        this.direction = newDirection;
        return this;
    }

    @Override
    public boolean isBidirectional() {
        return this.bidirectional;
    }

    @Override
    public Edge edge() {
        return (Edge)this.targetContainer;
    }

    @Override
    public void setReference(Long reference) {
        ((RelationshipModel)this.targetContainer).setId(reference);
    }

    @Override
    public void setPrimaryIdName(String primaryIdName) {
        ((RelationshipModel)this.targetContainer).setPrimaryIdName(primaryIdName);
    }

    @Override
    public RelationshipBuilder setVersionProperty(String name, Long version) {
        ((RelationshipModel)this.targetContainer).setVersion((Property)new PropertyModel((Object)name, (Object)version));
        return this;
    }
}

