/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class ByteArrayWrapperBase64Converter
implements AttributeConverter<Byte[], String> {
    @Override
    public String toGraphProperty(Byte[] value) {
        if (value == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(ArrayUtils.toPrimitive((Byte[])value));
    }

    @Override
    public Byte[] toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(value);
        Byte[] wrapper = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            wrapper[i] = bytes[i];
        }
        return wrapper;
    }
}

