/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Objects;
import org.neo4j.ogm.context.Mappable;

public class MappedRelationship
implements Mappable {
    private final long startNodeId;
    private final String relationshipType;
    private final long endNodeId;
    private Long relationshipId;
    private Class startNodeType;
    private Class endNodeType;

    public MappedRelationship(long startNodeId, String relationshipType, long endNodeId, Class startNodeType, Class endNodeType) {
        this.startNodeId = startNodeId;
        this.relationshipType = relationshipType;
        this.endNodeId = endNodeId;
        this.startNodeType = startNodeType;
        this.endNodeType = endNodeType;
    }

    public MappedRelationship(long startNodeId, String relationshipType, long endNodeId, Long relationshipId, Class startNodeType, Class endNodeType) {
        this.startNodeId = startNodeId;
        this.relationshipType = relationshipType;
        this.endNodeId = endNodeId;
        this.relationshipId = relationshipId;
        this.startNodeType = startNodeType;
        this.endNodeType = endNodeType;
    }

    @Override
    public long getStartNodeId() {
        return this.startNodeId;
    }

    @Override
    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Override
    public long getEndNodeId() {
        return this.endNodeId;
    }

    public Long getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(Long relationshipId) {
        this.relationshipId = relationshipId;
    }

    public void activate() {
    }

    @Override
    public Class getEndNodeType() {
        return this.endNodeType;
    }

    @Override
    public Class getStartNodeType() {
        return this.startNodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedRelationship that = (MappedRelationship)o;
        return this.startNodeId == that.startNodeId && this.endNodeId == that.endNodeId && Objects.equals(this.relationshipType, that.relationshipType) && Objects.equals(this.relationshipId, that.relationshipId);
    }

    public int hashCode() {
        return Objects.hash(this.startNodeId, this.relationshipType, this.endNodeId, this.relationshipId);
    }

    public String toString() {
        return String.format("(%s)-[%s:%s]->(%s)", this.startNodeId, this.relationshipId, this.relationshipType, this.endNodeId);
    }
}

