/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class FieldsInfo {
    private final Map<String, FieldInfo> fields = new HashMap<String, FieldInfo>();

    FieldsInfo() {
    }

    public FieldsInfo(ClassInfo classInfo, Class<?> cls, TypeSystem typeSystem) {
        for (Field field : cls.getDeclaredFields()) {
            ObjectAnnotations objectAnnotations;
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || (objectAnnotations = ObjectAnnotations.of(field.getDeclaredAnnotations())).has(Transient.class)) continue;
            String typeParameterDescriptor = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length > 0) {
                    for (Type typeArgument : actualTypeArguments) {
                        if (typeArgument instanceof ParameterizedType) {
                            ParameterizedType parameterizedTypeArgument = (ParameterizedType)typeArgument;
                            typeParameterDescriptor = parameterizedTypeArgument.getRawType().getTypeName();
                            break;
                        }
                        if ((typeArgument instanceof TypeVariable || typeArgument instanceof WildcardType) && !objectAnnotations.has(Relationship.class)) {
                            typeParameterDescriptor = Object.class.getName();
                            break;
                        }
                        if (!(typeArgument instanceof Class)) continue;
                        typeParameterDescriptor = ((Class)typeArgument).getName();
                    }
                }
                if (typeParameterDescriptor == null) {
                    typeParameterDescriptor = parameterizedType.getRawType().getTypeName();
                }
            }
            if (typeParameterDescriptor == null && genericType instanceof TypeVariable) {
                typeParameterDescriptor = field.getType().getTypeName();
            }
            boolean isSupportedNativeType = typeSystem.supportsAsNativeType(field.getType());
            this.fields.put(field.getName(), new FieldInfo(classInfo, field, typeParameterDescriptor, objectAnnotations, isSupportedNativeType));
        }
    }

    public Collection<FieldInfo> fields() {
        return this.fields.values();
    }

    public Collection<FieldInfo> compositeFields() {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (FieldInfo field : this.fields()) {
            if (!field.hasCompositeConverter()) continue;
            fields.add(field);
        }
        return Collections.unmodifiableList(fields);
    }

    FieldInfo get(String name) {
        return this.fields.get(name);
    }

    public void append(FieldsInfo fieldsInfo) {
        for (FieldInfo fieldInfo : fieldsInfo.fields()) {
            if (this.fields.containsKey(fieldInfo.getName())) continue;
            this.fields.put(fieldInfo.getName(), fieldInfo);
        }
    }
}

