/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.context.LabelHistory;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

class IdentityMap {
    private static final long SEED = -197749L;
    private final Map<Long, Long> nodeHash = new HashMap<Long, Long>();
    private final Map<Long, Long> relEntityHash = new HashMap<Long, Long>();
    private final Map<Long, LabelHistory> labelHistoryRegister = new HashMap<Long, LabelHistory>();
    private final MetaData metaData;

    IdentityMap(MetaData metaData) {
        this.metaData = metaData;
    }

    void remember(Object object, Long entityId) {
        ClassInfo classInfo = this.metaData.classInfo(object);
        if (this.metaData.isRelationshipEntity(classInfo.name())) {
            this.relEntityHash.put(entityId, this.hash(object, classInfo));
        } else {
            this.nodeHash.put(entityId, this.hash(object, classInfo));
        }
        this.collectLabelHistory(object, entityId, classInfo);
    }

    boolean remembered(Object object, Long entityId) {
        ClassInfo classInfo = this.metaData.classInfo(object);
        boolean isRelEntity = false;
        if (entityId != null) {
            if (this.metaData.isRelationshipEntity(classInfo.name())) {
                isRelEntity = true;
            }
            if (!isRelEntity && !this.nodeHash.containsKey(entityId) || isRelEntity && !this.relEntityHash.containsKey(entityId)) {
                return false;
            }
            long actual = this.hash(object, classInfo);
            long expected = isRelEntity ? this.relEntityHash.get(entityId).longValue() : this.nodeHash.get(entityId).longValue();
            return actual == expected;
        }
        return false;
    }

    private void collectLabelHistory(Object entity, Long entityId, ClassInfo classInfo) {
        FieldInfo fieldInfo = classInfo.labelFieldOrNull();
        if (fieldInfo != null) {
            Collection labels = (Collection)fieldInfo.read(entity);
            this.labelHistory(entityId).push(labels);
        }
    }

    LabelHistory labelHistory(Long entityId) {
        return this.labelHistoryRegister.computeIfAbsent(entityId, k -> new LabelHistory());
    }

    void clear() {
        this.nodeHash.clear();
        this.relEntityHash.clear();
        this.labelHistoryRegister.clear();
    }

    private long hash(Object object, ClassInfo classInfo) {
        long hash = -197749L;
        ArrayList<FieldInfo> hashFields = new ArrayList<FieldInfo>(classInfo.propertyFields());
        if (classInfo.labelFieldOrNull() != null) {
            hashFields.add(classInfo.labelFieldOrNull());
        }
        for (FieldInfo fieldInfo : hashFields) {
            Field field = classInfo.getField(fieldInfo);
            Object value = FieldInfo.read(field, object);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                hash = hash * 31L + (long)Arrays.hashCode(this.convertToObjectArray(value));
                continue;
            }
            if (value instanceof Iterable) {
                hash = hash * 31L + (long)value.hashCode();
                continue;
            }
            hash = hash * 31L + this.hash(value.toString());
        }
        return hash;
    }

    private long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    private Object[] convertToObjectArray(Object array) {
        int len = Array.getLength(array);
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Array.get(array, i);
        }
        return Arrays.asList(out).toArray();
    }
}

