/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.AttributeConverters;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ConversionCallbackRegistry;
import org.neo4j.ogm.typeconversion.ConvertibleTypes;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainInfo.class);
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private final Map<String, ArrayList<ClassInfo>> annotationNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Map<String, ArrayList<ClassInfo>> interfaceNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Set<Class> enumTypes = new HashSet<Class>();
    private final ConversionCallbackRegistry conversionCallbackRegistry = new ConversionCallbackRegistry();

    public static DomainInfo create(String ... packages) {
        ScanResult scanResult = new FastClasspathScanner(packages).strictWhitelist().scan();
        List allClasses = scanResult.getNamesOfAllClasses();
        DomainInfo domainInfo = new DomainInfo();
        allClasses.forEach(className -> DomainInfo.prepareClass(domainInfo, className));
        domainInfo.finish();
        return domainInfo;
    }

    private static void prepareClass(DomainInfo domainInfo, String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Could not load class {}", (Object)className);
        }
        ClassInfo classInfo = new ClassInfo(cls);
        String superclassName = classInfo.superclassName();
        LOGGER.debug("Processing: {} -> {}", (Object)className, (Object)superclassName);
        if (!(className == null || cls.isAnnotation() || cls.isAnonymousClass() || cls.equals(Object.class))) {
            ClassInfo thisClassInfo = domainInfo.classNameToClassInfo.computeIfAbsent(className, k -> classInfo);
            if (!thisClassInfo.hydrated()) {
                thisClassInfo.hydrate(classInfo);
                ClassInfo superclassInfo = domainInfo.classNameToClassInfo.get(superclassName);
                if (superclassInfo == null) {
                    if (superclassName != null && !superclassName.equals("java.lang.Object") && !superclassName.equals("java.lang.Enum")) {
                        domainInfo.classNameToClassInfo.put(superclassName, new ClassInfo(superclassName, thisClassInfo));
                        DomainInfo.prepareClass(domainInfo, superclassName);
                    }
                } else {
                    superclassInfo.addSubclass(thisClassInfo);
                }
            }
            if (thisClassInfo.isEnum()) {
                LOGGER.debug("Registering enum class: {}", (Object)thisClassInfo.name());
                domainInfo.enumTypes.add(thisClassInfo.getUnderlyingClass());
            }
        }
    }

    private void buildAnnotationNameToClassInfoMap() {
        LOGGER.info("Building annotation class map");
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            for (AnnotationInfo annotation : classInfo.annotations()) {
                ArrayList<ClassInfo> classInfoList = this.annotationNameToClassInfo.get(annotation.getName());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.annotationNameToClassInfo.put(annotation.getName(), classInfoList);
                }
                classInfoList.add(classInfo);
            }
        }
    }

    private void buildInterfaceNameToClassInfoMap() {
        LOGGER.info("Building interface class map for {} classes", (Object)this.classNameToClassInfo.values().size());
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            LOGGER.debug(" - {} implements {} interfaces", (Object)classInfo.simpleName(), (Object)classInfo.interfacesInfo().list().size());
            for (InterfaceInfo iface : classInfo.interfacesInfo().list()) {
                ArrayList<ClassInfo> classInfoList = this.interfaceNameToClassInfo.get(iface.name());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.interfaceNameToClassInfo.put(iface.name(), classInfoList);
                }
                LOGGER.debug("   - {}", (Object)iface.name());
                classInfoList.add(classInfo);
            }
        }
    }

    void registerConversionCallback(ConversionCallback conversionCallback) {
        this.conversionCallbackRegistry.registerConversionCallback(conversionCallback);
    }

    private void finish() {
        LOGGER.info("Starting Post-processing phase");
        this.buildAnnotationNameToClassInfoMap();
        this.buildInterfaceNameToClassInfoMap();
        ArrayList<ClassInfo> transientClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.name() == null || classInfo.name().equals("java.lang.Object")) continue;
            LOGGER.debug("Post-processing: {}", (Object)classInfo.name());
            if (classInfo.isTransient()) {
                LOGGER.debug(" - Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
                continue;
            }
            if (classInfo.superclassName() == null || classInfo.superclassName().equals("java.lang.Object")) {
                this.extend(classInfo, classInfo.directSubclasses());
            }
            for (InterfaceInfo interfaceInfo : classInfo.interfacesInfo().list()) {
                this.implement(classInfo, interfaceInfo);
            }
        }
        LOGGER.debug("Checking for @Transient classes....");
        Collection<ArrayList<ClassInfo>> interfaceInfos = this.interfaceNameToClassInfo.values();
        for (ArrayList<ClassInfo> arrayList : interfaceInfos) {
            for (ClassInfo classInfo : arrayList) {
                if (!classInfo.isTransient()) continue;
                LOGGER.debug("Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
            }
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        for (ClassInfo classInfo : transientClasses) {
            hashSet.addAll(this.removeTransientClass(classInfo));
        }
        LOGGER.debug("Registering converters and deregistering transient fields and methods....");
        this.postProcessFields(hashSet);
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            classInfo.primaryIndexField();
            classInfo.getVersionField();
        }
        LOGGER.info("Post-processing complete");
    }

    private void postProcessFields(Set<Class> transientClassesRemoved) {
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            boolean registerConverters = false;
            if (!classInfo.isEnum() && !classInfo.isInterface()) {
                registerConverters = true;
            }
            Iterator<FieldInfo> fieldInfoIterator = classInfo.fieldsInfo().fields().iterator();
            while (fieldInfoIterator.hasNext()) {
                FieldInfo fieldInfo = fieldInfoIterator.next();
                if (!fieldInfo.persistableAsProperty()) {
                    Class<?> fieldClass = null;
                    try {
                        fieldClass = ClassUtils.getType(fieldInfo.getTypeDescriptor());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Unable to compute class type for " + classInfo.name() + ", field: " + fieldInfo.getName());
                    }
                    if (fieldClass != null && transientClassesRemoved.contains(fieldClass)) {
                        fieldInfoIterator.remove();
                        continue;
                    }
                }
                if (!registerConverters) continue;
                this.registerDefaultFieldConverters(classInfo, fieldInfo);
            }
        }
    }

    private Set<Class> removeTransientClass(ClassInfo transientClass) {
        HashSet<Class> removed = new HashSet<Class>();
        if (transientClass != null && !transientClass.name().equals("java.lang.Object")) {
            LOGGER.debug("Removing @Transient class: {}", (Object)transientClass.name());
            this.classNameToClassInfo.remove(transientClass.name());
            removed.add(transientClass.getUnderlyingClass());
            for (ClassInfo transientChild : transientClass.directSubclasses()) {
                this.removeTransientClass(transientChild);
            }
            for (ClassInfo transientChild : transientClass.directImplementingClasses()) {
                this.removeTransientClass(transientChild);
            }
        }
        return removed;
    }

    private void extend(ClassInfo superclass, List<ClassInfo> subclasses) {
        for (ClassInfo subclass : subclasses) {
            subclass.extend(superclass);
            this.extend(subclass, subclass.directSubclasses());
        }
    }

    private void implement(ClassInfo implementingClass, InterfaceInfo interfaceInfo) {
        ClassInfo interfaceClass = this.classNameToClassInfo.get(interfaceInfo.name());
        if (interfaceClass != null) {
            if (!implementingClass.directInterfaces().contains(interfaceClass)) {
                LOGGER.debug(" - Setting {} implements {}", (Object)implementingClass.simpleName(), (Object)interfaceClass.simpleName());
                implementingClass.directInterfaces().add(interfaceClass);
            }
            if (!interfaceClass.directImplementingClasses().contains(implementingClass)) {
                interfaceClass.directImplementingClasses().add(implementingClass);
            }
            for (ClassInfo subClassInfo : implementingClass.directSubclasses()) {
                this.implement(subClassInfo, interfaceInfo);
            }
        } else {
            LOGGER.debug(" - No ClassInfo found for interface class: {}", (Object)interfaceInfo.name());
        }
    }

    public ClassInfo getClass(String fqn) {
        return this.classNameToClassInfo.get(fqn);
    }

    ClassInfo getClassSimpleName(String fullOrPartialClassName) {
        return this.getClassInfo(fullOrPartialClassName, this.classNameToClassInfo);
    }

    ClassInfo getClassInfoForInterface(String fullOrPartialClassName) {
        ClassInfo classInfo = this.getClassSimpleName(fullOrPartialClassName);
        if (classInfo != null && classInfo.isInterface()) {
            return classInfo;
        }
        return null;
    }

    private ClassInfo getClassInfo(String fullOrPartialClassName, Map<String, ClassInfo> infos) {
        ClassInfo match = null;
        for (String fqn : infos.keySet()) {
            if (!fqn.endsWith("." + fullOrPartialClassName) && !fqn.equals(fullOrPartialClassName)) continue;
            if (match == null) {
                match = infos.get(fqn);
                continue;
            }
            throw new MappingException("More than one class has simple name: " + fullOrPartialClassName);
        }
        return match;
    }

    List<ClassInfo> getClassInfosWithAnnotation(String annotation) {
        return this.annotationNameToClassInfo.get(annotation);
    }

    private void registerDefaultFieldConverters(ClassInfo classInfo, FieldInfo fieldInfo) {
        if (!fieldInfo.hasPropertyConverter() && !fieldInfo.hasCompositeConverter()) {
            String typeDescriptor = fieldInfo.getTypeDescriptor();
            Function<AttributeConverters, Optional> selectAttributeConverter = ac -> DomainInfo.selectAttributeConverterFor(fieldInfo, ac);
            Optional registeredAttributeConverter = ConvertibleTypes.REGISTRY.entrySet().stream().filter(e -> typeDescriptor.contains((CharSequence)e.getKey())).sorted(Comparator.comparingInt(e -> ((String)e.getKey()).length()).reversed()).findFirst().map(Map.Entry::getValue).flatMap(selectAttributeConverter);
            if (registeredAttributeConverter.isPresent()) {
                fieldInfo.setPropertyConverter((AttributeConverter)registeredAttributeConverter.get());
            } else {
                Class<?> fieldType;
                if (fieldInfo.getAnnotations().get(Convert.class) != null) {
                    Class<?> entityAttributeType = ClassUtils.getType(typeDescriptor);
                    String graphTypeDescriptor = fieldInfo.getAnnotations().get(Convert.class).get("graphPropertyType", null);
                    if (graphTypeDescriptor == null) {
                        throw new MappingException("Found annotation to convert a " + (entityAttributeType != null ? entityAttributeType.getName() : " null object ") + " on " + classInfo.name() + '.' + fieldInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                    }
                    fieldInfo.setPropertyConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
                }
                if ((fieldType = ClassUtils.getType(typeDescriptor)) == null) {
                    throw new RuntimeException("Class " + classInfo.name() + " field " + fieldInfo.getName() + " has null field type.");
                }
                boolean enumConverterSet = false;
                for (Class enumClass : this.enumTypes) {
                    if (!fieldType.equals(enumClass)) continue;
                    DomainInfo.setEnumFieldConverter(fieldInfo, enumClass);
                    enumConverterSet = true;
                    break;
                }
                if (!enumConverterSet && fieldType.isEnum()) {
                    LOGGER.debug("Setting default enum converter for unscanned class " + classInfo.name() + ", field: " + fieldInfo.getName());
                    DomainInfo.setEnumFieldConverter(fieldInfo, fieldType);
                }
            }
        }
    }

    public Map<String, ClassInfo> getClassInfoMap() {
        return this.classNameToClassInfo;
    }

    public List<ClassInfo> getClassInfos(String interfaceName) {
        return this.interfaceNameToClassInfo.get(interfaceName);
    }

    private static Optional<AttributeConverter<?, ?>> selectAttributeConverterFor(FieldInfo source, AttributeConverters from) {
        FieldInfo fieldInfo = Objects.requireNonNull(source, "Need a field info");
        AttributeConverters attributeConverters = Objects.requireNonNull(from, "Need the set of attribute converters for the given field info.");
        AttributeConverter<?, ?> selectedConverter = fieldInfo.isArray() ? attributeConverters.forArray : (fieldInfo.isIterable() ? attributeConverters.forIterable.apply(fieldInfo.getCollectionClassname()) : attributeConverters.forScalar);
        return Optional.ofNullable(selectedConverter);
    }

    private static void setEnumFieldConverter(FieldInfo fieldInfo, Class enumClass) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }
}

