/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.AttributeConverters;
import org.neo4j.ogm.typeconversion.ByteArrayBase64Converter;
import org.neo4j.ogm.typeconversion.ByteArrayWrapperBase64Converter;
import org.neo4j.ogm.typeconversion.ConverterBasedCollectionConverter;
import org.neo4j.ogm.typeconversion.DateArrayStringConverter;
import org.neo4j.ogm.typeconversion.DateCollectionStringConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;
import org.neo4j.ogm.typeconversion.EnumArrayStringConverter;
import org.neo4j.ogm.typeconversion.EnumCollectionStringConverter;
import org.neo4j.ogm.typeconversion.EnumStringConverter;
import org.neo4j.ogm.typeconversion.InstantStringConverter;
import org.neo4j.ogm.typeconversion.LocalDateStringConverter;
import org.neo4j.ogm.typeconversion.LocalDateTimeStringConverter;
import org.neo4j.ogm.typeconversion.NumberArrayStringConverter;
import org.neo4j.ogm.typeconversion.NumberCollectionStringConverter;
import org.neo4j.ogm.typeconversion.NumberStringConverter;
import org.neo4j.ogm.typeconversion.OffsettDateTimeStringConverter;

public abstract class ConvertibleTypes {
    private static final String DATE_SIGNATURE = "java.util.Date";
    private static final String BIG_DECIMAL_SIGNATURE = "java.math.BigDecimal";
    private static final String BIG_INTEGER_SIGNATURE = "java.math.BigInteger";
    private static final String BYTE_ARRAY_SIGNATURE = "byte[]";
    private static final String BYTE_ARRAY_WRAPPER_SIGNATURE = "java.lang.Byte[]";
    private static final String INSTANT_SIGNATURE = "java.time.Instant";
    private static final String LOCAL_DATE_SIGNATURE = "java.time.LocalDate";
    private static final String LOCAL_DATE_TIME_SIGNATURE = "java.time.LocalDateTime";
    private static final String OFFSET_DATE_TIME_SIGNATURE = "java.time.OffsetDateTime";
    public static final Map<String, AttributeConverters> REGISTRY = ConvertibleTypes.buildRegistry();

    public static AttributeConverter<?, ?> getDateConverter() {
        return new DateStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static AttributeConverter<?, ?> getDateArrayConverter() {
        return new DateArrayStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static AttributeConverter<?, ?> getDateCollectionConverter(String collectionType) {
        try {
            Class<?> collectionClazz = Class.forName(collectionType, false, Thread.currentThread().getContextClassLoader());
            return new DateCollectionStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getEnumConverter(Class enumClass) {
        return new EnumStringConverter(enumClass);
    }

    public static AttributeConverter<?, ?> getEnumArrayConverter(Class enumClass) {
        return new EnumArrayStringConverter(enumClass);
    }

    public static AttributeConverter<?, ?> getEnumCollectionConverter(Class enumClass, String collectionType) {
        try {
            Class<?> collectionClazz = Class.forName(collectionType, false, Thread.currentThread().getContextClassLoader());
            return new EnumCollectionStringConverter(enumClass, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getBigIntegerConverter() {
        return new NumberStringConverter(BigInteger.class);
    }

    public static AttributeConverter<?, ?> getBigIntegerArrayConverter() {
        return new NumberArrayStringConverter(BigInteger.class);
    }

    public static AttributeConverter<?, ?> getBigIntegerCollectionConverter(String collectionType) {
        try {
            Class<?> collectionClazz = Class.forName(collectionType, false, Thread.currentThread().getContextClassLoader());
            return new NumberCollectionStringConverter(BigInteger.class, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getBigDecimalConverter() {
        return new NumberStringConverter(BigDecimal.class);
    }

    public static AttributeConverter<?, ?> getBigDecimalArrayConverter() {
        return new NumberArrayStringConverter(BigDecimal.class);
    }

    public static AttributeConverter<?, ?> getBigDecimalCollectionConverter(String collectionType) {
        try {
            Class<?> collectionClazz = Class.forName(collectionType, false, Thread.currentThread().getContextClassLoader());
            return new NumberCollectionStringConverter(BigDecimal.class, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getByteArrayBase64Converter() {
        return new ByteArrayBase64Converter();
    }

    public static AttributeConverter<?, ?> getByteArrayWrapperBase64Converter() {
        return new ByteArrayWrapperBase64Converter();
    }

    public static AttributeConverter<?, ?> getInstantConverter() {
        return new InstantStringConverter();
    }

    public static AttributeConverter<?, ?> getLocalDateConverter() {
        return new LocalDateStringConverter();
    }

    public static AttributeConverter<?, ?> getLocalDateTimeConverter() {
        return new LocalDateTimeStringConverter();
    }

    public static AttributeConverter<?, ?> getOffsetDateTimeConverter() {
        return new OffsettDateTimeStringConverter();
    }

    public static AttributeConverter<?, ?> getConverterBasedCollectionConverter(AttributeConverter<?, ?> converter, String collectionType) {
        try {
            Class<?> collectionClazz = Class.forName(collectionType, false, Thread.currentThread().getContextClassLoader());
            return new ConverterBasedCollectionConverter(collectionClazz, converter);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, AttributeConverters> buildRegistry() {
        HashMap<String, AttributeConverters> registry = new HashMap<String, AttributeConverters>();
        registry.put(DATE_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getDateConverter()).array(ConvertibleTypes.getDateArrayConverter()).andIterable(ct -> ConvertibleTypes.getDateCollectionConverter(ct)));
        registry.put(BIG_INTEGER_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getBigIntegerConverter()).array(ConvertibleTypes.getBigIntegerArrayConverter()).andIterable(ct -> ConvertibleTypes.getBigIntegerCollectionConverter(ct)));
        registry.put(BIG_DECIMAL_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getBigDecimalConverter()).array(ConvertibleTypes.getBigDecimalArrayConverter()).andIterable(ct -> ConvertibleTypes.getBigDecimalCollectionConverter(ct)));
        registry.put(INSTANT_SIGNATURE, AttributeConverters.Builder.onlyScalar(ConvertibleTypes.getInstantConverter()));
        registry.put(OFFSET_DATE_TIME_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getOffsetDateTimeConverter()).andIterable(ct -> ConvertibleTypes.getConverterBasedCollectionConverter(ConvertibleTypes.getOffsetDateTimeConverter(), ct)));
        registry.put(LOCAL_DATE_TIME_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getLocalDateTimeConverter()).andIterable(ct -> ConvertibleTypes.getConverterBasedCollectionConverter(ConvertibleTypes.getLocalDateTimeConverter(), ct)));
        registry.put(LOCAL_DATE_SIGNATURE, AttributeConverters.Builder.forScalar(ConvertibleTypes.getLocalDateConverter()).andIterable(ct -> ConvertibleTypes.getConverterBasedCollectionConverter(ConvertibleTypes.getLocalDateConverter(), ct)));
        registry.put(BYTE_ARRAY_SIGNATURE, AttributeConverters.Builder.onlyArray(ConvertibleTypes.getByteArrayBase64Converter()));
        registry.put(BYTE_ARRAY_WRAPPER_SIGNATURE, AttributeConverters.Builder.onlyArray(ConvertibleTypes.getByteArrayWrapperBase64Converter()));
        return Collections.unmodifiableMap(registry);
    }
}

